function plot3dhead(XScalp,YScalp,ZScalp,CalcPotTmp,dlgstatus,axesstatus,model)
%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      

plotheadstatus=1;


if nargin < 7; pause(1.1);model=questdlg('Please choose 3d-model-type:','3d-model-type:','head','brain','head');pause(0.1);end
if nargin < 6; axesstatus = 1;end
if nargin <5;dlgstatus= 0;end
if nargin<1; potential3dfilepath=which('potential.mat'); load(potential3dfilepath,'XScalp','YScalp','ZScalp','CalcPotTmp');end

%var
global patchmat vertexmat colors


if plotheadstatus == 1
    if dlgstatus==1
        answer = questdlg('Wollen Sie den Standardkopf verwenden oder eine anderen?','Kopfform:','standard','anderen','standard');
        if strcmp(model,'head')
            if strcmp(answer,'standard')
                if ~isempty(which('head3dsurf.mat'))
                    head3dfilepath=which('head3d.mat');
                        load(head3dfilepath,'vertexmat','patchmat');
                else
                    uiwait(errordlg('Konnte kein Standard-3d-file finden!','Achtung:'));
                    readASE;
                end
            else
                readASE;
            end
        elseif strcmp(model,'brain')
            if strcmp(answer,'standard')
                if ~isempty(which('brain3dpatch.mat'))
                 brain3dfilepath=which('brain3dpatch.mat');
                        load(brain3dfilepath,'vertexmat','patchmat');
                else
                    uiwait(errordlg('Konnte kein Standard-3d-file finden!','Achtung:'));
                    readASE;
                end
            else
                readASE;
            end
        end
    else
        if strcmp(model,'head')
             if ~isempty(which('head3dsurf.mat'))
                    head3dfilepath=which('head3dsurf.mat');
                        load(head3dfilepath,'vertexmat','patchmat');
            else
                answer = questdlg('Konnte kein Standard-3d-file finden! Mchten Sie ein Asci-Export-File auswhlen?','Fehlendes 3d-file:','ja','nein','ja');
                if strcmp(answer,'ja')
                    readASE;
                else
                    return
                end
            end
        elseif strcmp(model,'brain')
             if ~isempty(which('brain3dpatch.mat'))
                 brain3dfilepath=which('brain3dpatch.mat');
                        load(brain3dfilepath,'vertexmat','patchmat');
            else
                answer = questdlg('Konnte kein Standard-3d-file finden! Mchten Sie ein Asci-Export-File auswhlen?','Fehlendes 3d-file:','ja','nein','ja');
                if strcmp(answer,'ja')
                    readASE;
                else
                    return
                end
            end
        end
end


%kopfposition auf Ursprung
%-------------------------
diameterx=abs((max(vertexmat(:,1))-min(vertexmat(:,1))));
diametery=abs((max(vertexmat(:,2))-min(vertexmat(:,2))));
diameterz=abs((max(vertexmat(:,2))-min(vertexmat(:,2))));
targetx=0-0.5*diameterx;
targety=0-0.5*diametery;
targetz=0-0.5*diameterz;
diffx=min(vertexmat(:,1))-targetx;
diffy=min(vertexmat(:,2))-targety;
diffz=min(vertexmat(:,3))-targetz;
vertexmat(:,1)=vertexmat(:,1)-diffx;
vertexmat(:,2)=vertexmat(:,2)-diffy;
vertexmat(:,3)=vertexmat(:,3)-diffz;

if strcmp(model,'head')
	vertexmat(:,3)=vertexmat(:,3)-2;
	vertexmat(:,2)=vertexmat(:,2)-1;
elseif strcmp(model,'brain')
    vertexmat(:,3)=vertexmat(:,3)+1;
	vertexmat(:,2)=vertexmat(:,2);
end

kopfmittelpunkt = [0 0 0];

%calculate color
%-----------------
for vertexzaehler=1:length(vertexmat)
      vertex=vertexmat(vertexzaehler,:);
      vertexmatx=ones(size(XScalp))*vertex(1);
      vertexmaty=ones(size(XScalp))*vertex(2);
      vertexmatz=ones(size(ZScalp))*vertex(3);
      x=zeros(size(XScalp,1),size(XScalp,2),2);
      y=zeros(size(x));
      z=zeros(size(x));
      x(:,:,1)=vertexmatx;
      x(:,:,2)=XScalp;
      y(:,:,1)=vertexmaty;
      y(:,:,2)=YScalp;
      z(:,:,1)=vertexmatz;
      z(:,:,2)=ZScalp;
      distmat=dist3d(x,y,z);
      minimum=find(distmat==min(min(distmat)));
      if length(minimum>1)
          minimum=minimum(1);
      end
      [i,j]=ind2sub(size(XScalp),minimum);
      colormat(vertexzaehler)=CalcPotTmp(i,j);
    if mod(vertexzaehler,20)==0
        clc;
        fprintf([num2str(vertexzaehler),' of ',num2str(length(vertexmat)),' vertices colored...']);
    end
end
end



%figure
%----------
figure('Name','3d-view:','Numbertitle','off','color',[1 1 1],'menubar','figure');
hold on
warning off
colorvoltages=finddiffel(CalcPotTmp);
colorhelpmat=hsv(length(finddiffel(CalcPotTmp))+200);
for i=1:length(colormat)
    colors(i,:)=colorhelpmat(find(colorvoltages==colormat(i)),:);
end


%colored head surface
%---------------------
if plotheadstatus == 1
        
	patch('Vertices',vertexmat,'Faces',patchmat,'FaceVertexCData',colors,'FaceColor','interp','EdgeColor','none',...
        'facelighting','gouraud');
	h = light('position',[20 20 0],'style','infinite','Color',[0.5 0.5 0]);
	h = light('position',[-20 -20 0],'style','infinite','Color',[0.5 0.5 0]);
	set(gca,'Color','none');
	figurecolor=get(gcf,'Color');
	set(gca,'XTick',[]);
	set(gca,'YTick',[]);
	set(gca,'ZTick',[]);
	set(gca,'XTickLabel','');
	set(gca,'YTickLabel','');
	set(gca,'ZTickLabel','');
	set(gca,'XColor',figurecolor);
	set(gca,'YColor',figurecolor);
	set(gca,'ZColor',figurecolor);
	set(gca,'Color',figurecolor);
	axis equal;
end



%Bereich vergrern
xlim=get(gca,'xlim');
ylim=get(gca,'ylim');
zlim=get(gca,'zlim');
nullmat=[0 0];
if strcmp(model,'head')
xlim=[-3 3];
ylim=[-6 3];
zlim=[-7, 4];
elseif strcmp(model,'brain')
 xlim=[-3 3];
ylim=[-4 5];
zlim=[-2, 4];
end

set(gca,'xlim',xlim);
set(gca,'ylim',ylim);
set(gca,'zlim',zlim);


%Achsen
%----------
if axesstatus == 1
	xachse=plot3(xlim,nullmat,nullmat,'color',[0 0 0],'linewidth',2);
	yachse=plot3(nullmat,ylim,nullmat,'color',[0 0 0],'linewidth',2);
	zachse=plot3(nullmat,nullmat,zlim,'color',[0 0 0],'linewidth',2);
	%Achsentitel
	text(max(xlim)+max(xlim)*0.3,  0+max(ylim)*0.1,0+max(zlim)*0.1,'X','color',[0 0 0],'fontsize',14);
	text(0+max(xlim)*0.1,min(ylim)-max(ylim)*0.3,0+max(zlim)*0.1,'Y','color',[0 0 0],'fontsize',14);
	text(0+max(xlim)*0.1,0+max(ylim)*0.1,max(zlim)+max(zlim)*0.3,'Z','color',[0 0 0],'fontsize',14);
	
	%Pfeile der Achsen
	%X-Achse
	c1scaling=0.5;
	c2scaling=0.5;
	c3scaling=0.8;
	%Pfeil
	[c1,c2,c3] = cylinder(linspace(0,max(xlim)/10,20),20);
	c1=c1-mean(mean(c1));
	c1=c1*c1scaling;
	c2=c2-mean(mean(c2));
	c2=c2*c2scaling;
	c3=c3-mean(mean(c3));
	c3=c3*c3scaling;
	cylinderhandlex=surf(c1,c2,c3);
	%Drehen in Achsenrichtung
	rotate(cylinderhandlex,[0 1 0],270,[0 0 0]);
	c1=get(cylinderhandlex,'XData');
	c2=get(cylinderhandlex,'YData');
	c3=get(cylinderhandlex,'ZData');
	delete(cylinderhandlex);
	%Verschiebung in y-Richtung
	c1=c1+max(abs(xlim));
	cylinderhandlex=surf(c1,c2,c3,'EdgeColor','none','FaceColor',[0 0 0]);
	%Y-Achse
	c1scaling=0.5;
	c2scaling=0.5;
	c3scaling=0.8;
	%Pfeil
	[c1,c2,c3] = cylinder(linspace(0,max(xlim)/10,20),20);
	c1=c1-mean(mean(c1));
	c1=c1*c1scaling;
	c2=c2-mean(mean(c2));
	c2=c2*c2scaling;
	c3=c3-mean(mean(c3));
	c3=c3*c3scaling;
	cylinderhandley=surf(c1,c2,c3);
	%Drehen in Achsenrichtung
	rotate(cylinderhandley,[1 0 0],270,[0 0 0]);
	c1=get(cylinderhandley,'XData');
	c2=get(cylinderhandley,'YData');
	c3=get(cylinderhandley,'ZData');
	delete(cylinderhandley);
	%Verschiebung in y-Richtung
	c2=c2-max(abs(ylim));
	cylinderhandley=surf(c1,c2,c3,'EdgeColor','none','FaceColor',[0 0 0]);
	%Z-Achse
	c1scaling=0.5;
	c2scaling=0.5;
	c3scaling=0.8;
	%Pfeil
	[c1,c2,c3] = cylinder(linspace(0,max(xlim)/10,20),20);
	c1=c1-mean(mean(c1));
	c1=c1*c1scaling;
	c2=c2-mean(mean(c2));
	c2=c2*c2scaling;
	c3=c3-mean(mean(c3));
	c3=c3*c3scaling;
	cylinderhandlez=surf(c1,c2,c3);
	%Drehen in Achsenrichtung
	rotate(cylinderhandlez,[0 1 0],180,[0 0 0]);
	c1=get(cylinderhandlez,'XData');
	c2=get(cylinderhandlez,'YData');
	c3=get(cylinderhandlez,'ZData');
	delete(cylinderhandlez);
	%Verschiebung in z-Richtung
	c3=c3+max(zlim);
	cylinderhandlez=surf(c1,c2,c3,'EdgeColor','none','FaceColor',[0 0 0]);
end

hold off
rotate3d
view(45,20);


return