function plotheadsurface(filename,filepath)
%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      

clear all;
close all;
global x y z closepoint
if nargin < 2
    [filename,filepath]=uigetfile('*.txt','Bitte whlen Sie das Koordinaten-file aus:');
end
file=[filepath,filename];
fid=fopen(file,'rt');

line=fgetl(fid);
linezaehler=1;
warning off
x=[];
y=[];
z=[];

while line~=-1
    tabs=findstr(line,char(9));
    x(linezaehler)=str2num(line(1:tabs(1)-1));
    y(linezaehler)=str2num(line(tabs(1)+1:tabs(2)-1));
    z(linezaehler)=str2num(line(tabs(2):end));
    linezaehler = linezaehler +1;
    line = fgetl(fid);
end

warning on


%Mittelpunkt
%--------------
mittelx=mean(x);
mittely=mean(y);
mittelz=mean(z);


%range
%---------
xrange = abs(max(x)-min(x));
yrange = abs(max(y)-min(y));
zrange = abs(max(z)-min(z));
meanrange = mean([xrange yrange zrange]);


%distanzen zum Mittelpunkt
%-------------------
distmat=[];
for k=1:length(x)
    distmat(k)=dist3d([x(k) mittelx],[y(k) mittely],[z(k) mittelz]);
end


%first plot
%-------------
figure('Name','Basic plot','Numbertitle','off');
hold on
plot3(x,y,z,'.');
plot3(mittelx,mittely,mittelz,'marker','o','markersize',20,'color',[1 0 0],'markerfacecolor',[1 0 0]);
view(45,0)
pause(1)

startpoint=1;
i=1;
closepointcounter=1;
while startpoint<length(x)
    i=1;
	while i<length(x)
        if dist3d([x(startpoint) x(i)],[y(startpoint) y(i)],[z(startpoint) z(i)])<meanrange*0.01 & dist3d([x(startpoint) x(i)],[y(startpoint) y(i)],[z(startpoint) z(i)])~=0
            plot3([x(startpoint) x(i)],[y(startpoint) y(i)],[z(startpoint) z(i)],'color',[1 0 0],'markerfacecolor',[1 0 0],'linewidth',5);
            pause(0.05);
            closepoint(closepointcounter)=startpoint;
            closepointcounter=closepointcounter+1;
            i=1;
            break
        end
        i=i+1;
	end
	startpoint=startpoint+1;
    
end
    
    

%corrected plot
%---------------
figure('Name','Minimum distance criterium:','Numbertitle','off');
hold on
plot3(x,y,z,'.');
plot3(mittelx,mittely,mittelz,'marker','o','markersize',20,'color',[1 0 0],'markerfacecolor',[1 0 0]);


figure
plot3(x(closepoint),y(closepoint),z(closepoint),'.')

xtmp=x;
ytmp=y;
ztmp=z;
xtmp(closepoint)=[];
ytmp(closepoint)=[];
ztmp(closepoint)=[];
figure
plot3(xtmp,ytmp,ztmp,'.');

return
    