function readWRL(filepath,filename);
%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      
patchzaehler=1;
punktezaehler=1;
global vertexmat patchmat
cd('F:\users\Peter\3dhead');
if nargin<1
    [WRLfilename,WRLfilepath]=uigetfile('*.WRL','Bitte whlen Sie den WRL-Export von 3dmax aus:');
end
    
    WRLfile=[WRLfilepath,WRLfilename];
fid = fopen(WRLfile,'rt');


numvertex=[];
numpatch =[];
linestring = fgetl(fid);
%read vertices
%-----------------
while isempty(findstr('Coordinate { point',linestring))
    linestring = fgetl(fid);
end
linestring=fgetl(fid);
vertexzaehler=1;
vertexmat=[];
clc;
while isempty(findstr(linestring,']'))
    kommata=findstr(linestring,',');
    vertexmat(vertexzaehler,:)=str2num(linestring(1:kommata(1)-1));
    vertexzaehler=vertexzaehler+1;
    vertexmat(vertexzaehler,:)=str2num(linestring(kommata(1)+1:kommata(2)-1));
    vertexzaehler=vertexzaehler+1;
    if length(kommata)>2
        vertexmat(vertexzaehler,:)=str2num(linestring(kommata(2):kommata(3)-1));
        vertexzaehler=vertexzaehler+1;
    end
    linestring=fgetl(fid);
    if mod(vertexzaehler,20)==0
        clc;
        fprintf([num2str(vertexzaehler),' vertices read...','\n']);
        pause(0.001)
    end
end

kommata=findstr(linestring,',');
vertexmat(vertexzaehler,:)=str2num(linestring(1:kommata(1)-1));
vertexzaehler=vertexzaehler+1;
vertexmat(vertexzaehler,:)=str2num(linestring(kommata(1)+1:kommata(2)-1));
vertexzaehler=vertexzaehler+1;
vertexmat(vertexzaehler,:)=str2num(linestring(kommata(2):end-1));
vertexzaehler=vertexzaehler+1;
linestring=fgetl(fid);
 
clc;


fprintf('Done reading vertices!');
pause(1);


%read patches
%------------
while isempty(findstr('coordIndex [',linestring))
    linestring = fgetl(fid);
end

patchmatstring= fscanf(fid,'%c');
ende = findstr(patchmatstring,']');
patchmatstring(ende:end)=[];
kommata=findstr(patchmatstring,',');
patchmatstring(kommata)=[];
minuseins=findstr(patchmatstring,'-1');
patchmatstring(minuseins+1)=[];
minusmat=findstr(patchmatstring,' -');
patchmatstring(minusmat+1)=[];

linebreaks=findstr(patchmatstring,char(10));
patchmatstring(linebreaks)=[];

while ~isempty(findstr(patchmatstring,'  '));
    patchmatstring=strrep(patchmatstring,'  ',' ');
end
patchmathelpmat=str2num(patchmatstring);
if mod(length(patchmathelpmat),3)~=0
    modulus=mod(length(patchmathelpmat),3);
    
    for i=1:modulus
        patchmathelpmat(end)=[];
    end
end
    
patchmattri=reshape(patchmathelpmat,[3,length(patchmathelpmat)/3]);
patchmattri=patchmattri';

patchmatquad=zeros(1,4);
j=1;
while j<length(patchmattri)
    if length(finddiffel(patchmattri(j:j+1,:)))==4    
        patchmatquad((j-1)/2+1,:)=finddiffel(patchmattri(j:j+1,:))'
        j=j+2;
        pause
    else
        j=j+1
        disp(finddiffel(patchmattri(j:j+1,:)));
        pause
    end
end
    
return


patchmat=patchmat+1;
fprintf('Done reading patches!');
pause(0.001);
[savefilename,savefilepath]=uiputfile('*.mat','Please name the 3d-file:');
if isempty(findstr(savefilename,'.mat'))
    savefilename=[savefilename,'.mat'];
end
save([savefilepath,savefilename],'vertexmat','patchmat');


warning off
t=patch('Vertices',vertexmat,'Faces',patchmat,'FaceVertexCData',hsv(1),'FaceColor','flat','EdgeColor','none');
h = light('position',[0.1 0 0],'style','infinite','Color',[1 1 0]);
view(45,20);
% figure
% patchmat2=patchmat-1,
% t=patch('Vertices',vertexmat,'Faces',patchmat2,'FaceVertexCData',hsv(1),'FaceColor','flat','EdgeColor','none');
% h = light('position',[0.1 0 0],'style','infinite','Color',[1 1 0]);
% x=get(t,'XData');
% y=get(t,'YData');
% z=get(t,'ZData');

% testx=x;
% testy=y;
% testz=z;
% testx(size(testx,1)+1,:)=0;
% testy(size(testy,1)+1,:)=0;
% testz(size(testz,1)+1,:)=0;
% testx(2:size(testx,1),:)=x;
% testy(2:size(testy,1),:)=y;
% testz(2:size(testz,1),:)=z;


fclose(fid);
return