function [vpnummer,restpaare]=readpairs(umkodierstatus,filename,filepath)
%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      


if nargin <1;umkodierstatus = 0;end
if nargin <3;filepath=[];end
if nargin <2;[filename,filepath]=uigetfile('*.log','logfile auswhlen:');end
file=[filepath filename];

%vpnummer
%----------
vpnummer=str2num(filename(1:2));


%readpairs
%------------
filehandle=fopen(file,'rt');
filestring=fscanf(filehandle,'%s');
kleinerindices=findstr('<',filestring);
groesserindices=findstr('>',filestring);
anzahlkleiner=size(kleinerindices);
anzahlgroesser=size(groesserindices);
anzahlpairs=anzahlkleiner(2)+anzahlgroesser(2);
kleinerpairs=cell(anzahlkleiner(2),1);
groesserpairs=cell(anzahlgroesser(2),1);
for i=1:anzahlkleiner(2)
    pair=strcat(filestring(kleinerindices(i)+1),'>',filestring(kleinerindices(i)-1));
    kleinerpairs{i}=pair;
end;
for i=1:anzahlgroesser(2)
    pair=filestring(groesserindices(i)-1:groesserindices(i)+1);
    groesserpairs{i}=pair;
end;


allpairs=[kleinerpairs;groesserpairs];


%umkodierung nach farbrand
%-----------------------------

if umkodierstatus == 1

%farbrand
%   1 	2	3	4	5	6
% 					
%   1	1	2	3	2	3
%   2	3	1	1	3	2
%   3	2	3	2	1	1
%   4	4	4	4	4	4
%   5	5	5	5	5	5
%   6	6	6	6	6	6

    

farbrand=mod((vpnummer-1),6)+1;

if farbrand == 1

elseif farbrand == 2
    
    for s=1:length(allpairs)
        allpairs{s}(findstr(allpairs{s},'2'))='x';
        allpairs{s}(findstr(allpairs{s},'3'))='2';
        allpairs{s}(findstr(allpairs{s},'x'))='3';
    end
    
elseif farbrand == 3
  
    for s=1:length(allpairs)
        allpairs{s}(findstr(allpairs{s},'2'))='x'
        allpairs{s}(findstr(allpairs{s},'1'))='2'
        allpairs{s}(findstr(allpairs{s},'x'))='1'
    end
    
elseif farbrand == 4
    
    for s=1:length(allpairs)
        allpairs{s}(findstr(allpairs{s},'1'))='x';
        allpairs{s}(findstr(allpairs{s},'2'))='1';
        allpairs{s}(findstr(allpairs{s},'3'))='2';
        allpairs{s}(findstr(allpairs{s},'x'))='3';
    end
    
elseif farbrand == 5
    
    for s=1:length(allpairs)
        allpairs{s}(findstr(allpairs{s},'1'))='x';
        allpairs{s}(findstr(allpairs{s},'2'))='y';
        allpairs{s}(findstr(allpairs{s},'3'))='1';
        allpairs{s}(findstr(allpairs{s},'x'))='2';
        allpairs{s}(findstr(allpairs{s},'y'))='3';
    end
    
elseif farbrand == 6
    
    for s=1:length(allpairs)
        allpairs{s}(findstr(allpairs{s},'1'))='x';
        allpairs{s}(findstr(allpairs{s},'3'))='1';
        allpairs{s}(findstr(allpairs{s},'x'))='3';
    end
    
end


end


%relevante paare raussuchen
%--------------------------
restpaare=cell(1);
restpaare{15}=[];


for r=1:length(allpairs)
    if allpairs{r}(1)<allpairs{r}(3)
        
        if strcmp(allpairs{r},'1>2')
            index=1;
        elseif strcmp(allpairs{r},'1>3')
            index=2;
        elseif strcmp(allpairs{r},'1>4')
            index=3;
        elseif strcmp(allpairs{r},'1>5')
            index=4;
        elseif strcmp(allpairs{r},'1>6')
            index=5;
        elseif strcmp(allpairs{r},'2>3')
            index=6;
        elseif strcmp(allpairs{r},'2>4') 
            index=7;       
        elseif strcmp(allpairs{r},'2>5')
            index=8;
        elseif strcmp(allpairs{r},'2>6')
            index=9;
        elseif strcmp(allpairs{r},'3>4')
            index=10;
        elseif strcmp(allpairs{r},'3>5')
            index=11;
        elseif strcmp(allpairs{r},'3>6')
            index=12;
        elseif strcmp(allpairs{r},'4>5')
            index=13;
        elseif strcmp(allpairs{r},'4>6')
            index=14;
        elseif strcmp(allpairs{r},'5>6')
            index=15;
        end
            
        restpaare{index}=allpairs{r};
    end
end


return





