function seldraw
%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      

if ~isempty(findobj('Name','Repeated Measures ANOVA:'))
    anovastatus = 1;
    global hPlot3dMenuFig
    hPlot3dList=get(hPlot3dMenuFig,'Userdata');
    anovadata = get(hPlot3dList(133),'userdata');
    hPlot3dList=get(hPlot3dMenuFig,'Userdata');
    factor = get(hPlot3dList(131),'userdata');
    plot2dlibfilepath= which('plot3d.m');
	plot2dlibfilepath(findstr(plot2dlibfilepath,'Plot3d.m'):findstr(plot2dlibfilepath,'Plot3d.m')+7)=[];
	file= [plot2dlibfilepath,'anovautil.mat'];
	load(file,'plotstringcell');
else
   anovastatus = 0; 
end
global selectfilemonitor zachsestatus element gruppdims faktorstring anzahlfaktoren...
    stufenvec aktiverfaktor zielmat cellstr vergleichecell dim anzahldims anzahlstimuli...
    paramat operatorcell filenamecell filenamestatus stimnummercell...
    selectedstatus generalcolor mittelwertfarbe mittelwertfarbegroupstatus

if isempty(selectedstatus)
    selectedstatus=0;
end
handle=[];
%handles:

%allgemein
%------------
schaubildaxen=findobj('tag','schaubildaxen');
figure(schaubildaxen);
cla reset
flipxachsebutton = findobj('tag','flipxachsebutton');
flipyachsebutton = findobj('tag','flipyachsebutton');
if ~isempty(get(flipxachsebutton,'Value'))
    if get(flipxachsebutton,'Value')==1
        set(gca,'xdir','reverse');
    else
        set(gca,'xdir','normal');
    end
end

if ~isempty(get(flipyachsebutton,'Value'))
    if get(flipyachsebutton,'Value')==1
        set(gca,'ydir','reverse');
    else
        set(gca,'ydir','normal');
    end
end

set(gca,'XColor',[0 0 0]);
set(gca,'YColor',[0 0 0]);

%dateinamen
%-------------
dateinamenradio = findobj('Tag','dateinamenradio');
filenamen = get(dateinamenradio,'Value');
dateinamenpopup = findobj('tag','dateinamenpopup');
if ~isempty(get(dateinamenpopup,'Value'))
    dateinamenfontsizestring=get(dateinamenpopup,'String');
    dateinamenfontsize=str2num(dateinamenfontsizestring{get(dateinamenpopup,'Value')});
else
    dateinamenfontsize=6;
end
dateinamenfontsize=13;


%selectitemsgui
%_---------------
cell1popup=findobj('tag','cell1auswahl');
cell2popup=findobj('tag','cell2auswahl');
operatorpopup=findobj('tag','operatorpopup');
vergleichemonitor = findobj('Tag','vergleichemonitor');
requirements = get(vergleichemonitor,'string');
alphapopup=findobj('tag','alphapopup');
dimensionauswahl=findobj('tag','dimensionauswahl');
addbutton=findobj('tag','addbutton');
scenarioradio=findobj('tag','scenarioradio');



%draw
%-------------
drawbutton=findobj('tag','drawbutton');

%Generalformatting
%---------------------------
generalcoloredit=findobj('tag','generalcoloredit');
generalmarkerpopup=findobj('tag','generalmarkerpopup');
generalmarkerstring=get(generalmarkerpopup,'string');
if ~isempty(get(generalmarkerpopup,'value'))
    generalmarker=generalmarkerstring{get(generalmarkerpopup,'Value')};
else
    generalmarker=generalmarkerstring{3};
end
generalmarkersizepopup=findobj('tag','generalmarkersizepopup');
if ~isempty(get(generalmarkersizepopup,'value'))
    generalmarkersize=get(generalmarkersizepopup,'Value');
else
    generalmarkersize=1;
end
generallinewidthpopup=findobj('tag','generallinewidthpopup');
if ~isempty(get(generallinewidthpopup,'Value'))
    generallinewidth=get(generallinewidthpopup,'Value');
else
    generallinewidth=1;
end

%achsen
%------------
xachsenpopup=findobj('tag','xachsenpopup');
aktivexachsecell=get(xachsenpopup,'String');
aktivexachse=get(xachsenpopup,'Value')-1;
if anovastatus
    nrofcells = plotstringcell{aktivexachse,3}
end
yachsenpopup=findobj('tag','yachsenpopup');
aktiveyachsecell=get(yachsenpopup,'String');
aktiveyachse=get(yachsenpopup,'Value')-1;
zachsenpopup=findobj('tag','zachsenpopup');
aktivezachsecell=get(zachsenpopup,'String');
aktivezachse=get(zachsenpopup,'Value')-1;
xrangevec=get(gca,'xlim');
xrange=abs(diff(xrangevec));
yrangevec=get(gca,'ylim');
yrange=abs(diff(yrangevec));

%Gruppen
%-------------
gruppenfarbenradio = findobj('Tag','gruppenfarbenradio');
gruppenfarben = get(gruppenfarbenradio,'Value');
gruppenradio = findobj('Tag','gruppenradio');
gruppenpopup=findobj('tag','gruppenpopup');
gruppenpopupcell=get(gruppenpopup,'String');
gruppenvarstatus = get(gruppenradio,'Value');
nullgruppenradio = findobj('tag','nullgruppenradio');
nullgruppenstatus = get(nullgruppenradio,'Value');
if isempty(nullgruppenstatus)
    nullgruppenstatus = 0;
end
if strcmp(get(gruppenpopup,'Enable'),'on')
    aktivegruppe=get(gruppenpopup,'Value');
else
    aktivegruppe=[];
end


%colormap
%-------------
colormappopup=findobj('tag','colormappopup');
colormapauswahl=get(colormappopup,'Value');
colormapnames=get(colormappopup,'string');
if ~isempty(colormapauswahl)
    colormap(colormapnames{colormapauswahl});
else
    colormap('hsv');
end
colormapmat=colormap;

%markermap
%------------
markermap={'+';'o';'*';'.';'x';'square';'diamond';'v';'^';'>';'<';'pentagram';'hexagram'};
%markerauswahl vernder
%------------------------
markermap=shuffle(markermap);
gruppensymboleradio=findobj('tag','gruppensymboleradio');
symbolschemapopup=findobj('tag','symbolschemapopup');
if ~isempty(get(gruppensymboleradio,'Value'))
    gruppensymbolestatus= get(gruppensymboleradio,'Value');
    if gruppensymbolestatus == 1
        if ~isempty(get(symbolschemapopup,'value'))
            symbolschema=get(symbolschemapopup,'value');
        else
            symbolschema=1;
        end
    end
else
    gruppensymbolestatus = 0;
end
gruppenmarkersizepopup=findobj('tag','gruppenmarkersizepopup');
if ~isempty(get(gruppenmarkersizepopup,'Value'))
    gruppenmarkersize=get(gruppenmarkersizepopup,'Value');
else
    gruppenmarkersize=1;
end


%Mittelwertformat und -farbe
%----------------------------
mittelwertsymbolpopup = findobj('tag','mittelwertsymbolpopup');
mittelwertfarbedit = findobj('tag','mittelwertfarbedit');
mittelwertmarkersizepopup = findobj('tag','mittelwertmarkersizepopup');
mittelwertlinewidthpopup = findobj('tag','mittelwertlinewidthpopup');
if ~isempty(get(mittelwertsymbolpopup,'Value'))
    mittelwertsymbolstring=get(mittelwertsymbolpopup,'String');
    mittelwertsymbolvalue=get(mittelwertsymbolpopup,'Value');
    mittelwertsymbol=mittelwertsymbolstring{mittelwertsymbolvalue};
else
    mittelwertsymbol='o';
end

if ~isempty(get(mittelwertmarkersizepopup,'Value'))
    mittelwertmarkersize=get(mittelwertmarkersizepopup,'Value');
else
    mittelwertmarkersize='1';
end  
if ~isempty(get(mittelwertlinewidthpopup,'Value'))
    mittelwertlinewidth=get(mittelwertlinewidthpopup,'Value');
else
    mittelwertlinewidth='1';
end 



anzahlreqs=length(requirements);
anzahlgruppen=length(cellstr);
formatpopup = findobj('tag','formatpopup');
aktivesformat = get(formatpopup,'Value');  
gruppenmittelwerteradio = findobj('Tag','gruppenmittelwerteradio');
gruppenmittelwerte = get(gruppenmittelwerteradio,'Value');
if iscell(aktivexachse)
    aktivexachse=aktivexachse{1};
end
 if iscell(aktiveyachse)
    aktiveyachse=aktiveyachse{1};
end
if iscell(aktivezachse)
    aktivezachse=aktivezachse{1};
end
if iscell(aktivesformat)
    aktivesformat=aktivesformat{2};
end
if iscell(aktivegruppe)
    aktivegruppe=aktivegruppe{1};
end  
celladressmat=zeros(length(cellstr),1);
for i=1:length(cellstr)
celladressmat(i,1)=str2num(strrep(strrep(cellstr{i},' ',''),'cell',''));
end




if aktiveyachse == 0 | aktivexachse == 0
    uiwait(errordlg('Sie mssen Achsendimensionen auswhlen bevor Schaubild gezeichnet werden kann!','Achtung:'));
    return
end
    
    
    
    

%Requirements analyzieren
%-----------------------------
groessenreqinds=zeros(1,3); % :  reqnumber ; gruppengroesse ; celladdress;
j=1;
absolutreqs =cell(1,4); % reqnumber; absolutWert ; celladdress ; dimension; operator;
k=1;
kleinerreqs = cell(1,4); %reqnumber; cell1adress; cell2adress; dimension; alpha;
l_k=1;
groesserreqs = cell(1,4); %reqnumber; cell1adress; cell2adress; dimension; alpha;
l_g=1;
gleichreqs = cell(1,4); %reqnumber; cell1adress; cell2adress; dimension; alpha;
l_e=1;

for i=1:anzahlreqs
    if ~isempty(findstr(requirements{i},'anzahl'))
        groessenreqinds(j,1) = i;
        groessenreqinds(j,2) = str2num(requirements{i}(findstr(requirements{i},'n#=')+3:findstr(requirements{i},':')-1));
        groessenreqinds(j,3) = str2num(requirements{i}(findstr(requirements{i},'cell')+4:findstr(requirements{i},'n#=')-1));
        j=j+1;
    elseif ~isempty(findstr(requirements{i},'|>|'))
        absolutreqs{k,1} = i;
        absolutreqs{k,2} = str2num(requirements{i}(findstr(requirements{i},'|>|')+3:findstr(requirements{i},':')-1));
        absolutreqs{k,3} = str2num(requirements{i}(findstr(requirements{i},'cell')+4:findstr(requirements{i},'|>|')-1));
        absolutreqs{k,4} = requirements{i}(findstr(requirements{i},':')+1:findstr(requirements{i},'-')-1);
        absolutreqs{k,5} = requirements{i}(findstr(requirements{i},'|>|')+1);
        k=k+1;
    elseif ~isempty(findstr(requirements{i},'|<|'))
        absolutreqs{k,1} = i;
        absolutreqs{k,2} = str2num(requirements{i}(findstr(requirements{i},'|<|')+3:findstr(requirements{i},':')-1));
        absolutreqs{k,3} = str2num(requirements{i}(findstr(requirements{i},'cell')+4:findstr(requirements{i},'|<|')-1));
        absolutreqs{k,4} = requirements{i}(findstr(requirements{i},':')+1:findstr(requirements{i},'-')-1);
        absolutreqs{k,5} = requirements{i}(findstr(requirements{i},'|<|')+1);
        
        k=k+1;
    elseif ~isempty(findstr(requirements{i},' < '))
        kleinerreqs{l_k,1} = i;
        kleinerreqs{l_k,2} = str2num(requirements{i}(5:findstr(requirements{i},' < ')-1));
        kleinerreqs{l_k,3} = str2num(requirements{i}(findstr(requirements{i},' < ')+7:findstr(requirements{i},':')-1));
        kleinerreqs{l_k,4} = requirements{i}(findstr(requirements{i},':')+1:findstr(requirements{i},'-')-1);
        kleinerreqs{l_k,5} = str2num(requirements{i}(findstr(requirements{i},'-')+1:findstr(requirements{i},'-')+5));
        l_k=l_k+1;
    elseif ~isempty(findstr(requirements{i},' > '))
        groesserreqs{l_g,1} = i;
        groesserreqs{l_g,2} = str2num(requirements{i}(5:findstr(requirements{i},' > ')-1));
        groesserreqs{l_g,3} = str2num(requirements{i}(findstr(requirements{i},' > ')+7:findstr(requirements{i},':')-1));
        groesserreqs{l_g,4} = requirements{i}(findstr(requirements{i},':')+1:findstr(requirements{i},'-')-1);
        groesserreqs{l_g,5} = str2num(requirements{i}(findstr(requirements{i},'-')+1:findstr(requirements{i},'-')+5));
        l_g=l_g+1;
    elseif ~isempty(findstr(requirements{i},' = '))
        gleichreqs{l_e,1} = i;
        gleichreqs{l_e,2} = str2num(requirements{i}(5:findstr(requirements{i},' = ')-1));
        gleichreqs{l_e,3} = str2num(requirements{i}(findstr(requirements{i},' = ')+7:findstr(requirements{i},':')-1));
        gleichreqs{l_e,4} = requirements{i}(findstr(requirements{i},':')+1:findstr(requirements{i},'-')-1);
        gleichreqs{l_e,5} = str2num(requirements{i}(findstr(requirements{i},'-')+1:findstr(requirements{i},'-')+5));
        l_e=l_e+1;
    else
        msgbox('Es spukt in selectitemsmain!!');
    end    
end

%farbenvec

if selectedstatus == 1
    %---------------
    farbenvec=zeros(size(groessenreqinds,1)+3,3);
    for k=1:size(groessenreqinds,1)
        farbenvec(k,:)=colormapmat(round(size(colormap,1)/(size(groessenreqinds,1)+3))+round(size(colormap,1)/(size(groessenreqinds,1)+3))*(k-1),:);
    end    
else
    farbenvec=zeros(length(finddiffel(paramat(:,gruppdims(aktivegruppe))))+3,3);
    for k=1:length(finddiffel(paramat(:,gruppdims(aktivegruppe)))+3)
        farbenvec(k,:)=colormapmat(round(size(colormap,1)/(length(finddiffel(paramat(:,gruppdims(aktivegruppe))))+3))+round(size(colormap,1)/(length(finddiffel(paramat(:,gruppdims(aktivegruppe))))+3))*(k-1),:);
    end       
end



    


%Punkte zeichen
%---------------------
if gruppenfarben~=1 & gruppensymbolestatus~=1
	x=zeros(size(paramat,1),1);
	for j=1:size(paramat,1)
		x(j)=paramat(j,aktivexachse);
        
	end
	y=zeros(size(paramat,1),1);
	for k=1:size(paramat,1)
	    y(k)=paramat(k,aktiveyachse);
        
	end
	if zachsestatus ==1
	z=zeros(size(paramat,1),1);
	for k=1:size(paramat,1)
	z(k)=paramat(k,aktivezachse);
	end
	end
	if zachsestatus ==1
        hold on
        for t=1:length(x)
            plot3(x(t),y(t),z(t),'Marker',generalmarker,'MarkerSize',generalmarkersize,'color',generalcolor,'markerfacecolor',generalcolor,'markeredgecolor',generalcolor)
        end
        hold off
	else
        hold on
        for t=1:length(x)
            plot(x(t),y(t),'Marker',generalmarker,'MarkerSize',generalmarkersize,'color',generalcolor,'markerfacecolor',generalcolor,'markeredgecolor',generalcolor)
        end
        hold off
    end
	%stimulinamen
	%--------------------
	dateinamenradio = findobj('Tag','dateinamenradio');
	filenamen = get(dateinamenradio,'Value');
	if filenamen==1
        hold on
        for k=1:anzahlstimuli
            text(x(k)*1.02,y(k),filenamecell{k},'FontSize',dateinamenfontsize,'Color',[0 0 0]);
        end
        hold off
	end
end






%Gruppenfarben & -symbole
%-----------------------
figure(schaubildaxen);
if gruppenfarben==1 | gruppensymbolestatus == 1
    hold on
    if isempty(aktivegruppe) & selectedstatus == 0
        errordlg('Gruppenfarben knnen erst angezeigt werden wenn Gruppen erstellt wurden oder eine Gruppierungsvariabel gewhlt wurde!','Fehler!');
        return
    %selectedmodus
    %----------------
    elseif selectedstatus ==1 & isempty(aktivegruppe)
        t=1;
        for k=1:size(groessenreqinds,1)
            if groessenreqinds(k,2)>0
               for n=1:groessenreqinds(k,2)                   
                    if gruppenfarben ==1 & gruppensymbolestatus == 1
                         handle(find(groessenreqinds(k,3)==celladressmat))=plot(paramat(stimnummercell{find(groessenreqinds(k,3)==celladressmat)}(n),aktivexachse),paramat(stimnummercell{find(groessenreqinds(k,3)==celladressmat)}(n),aktiveyachse),...
                             'color',farbenvec(find(groessenreqinds(k,3)==celladressmat)+1,:));
                         set(handle(find(groessenreqinds(k,3)==celladressmat)),'marker',markermap{find(groessenreqinds(k,3)==celladressmat)+1},'markerfacecolor',farbenvec(find(groessenreqinds(k,3)==celladressmat)+1,:),'markersize',gruppenmarkersize);
                    elseif gruppenfarben ==1 & gruppensymbolestatus ==0
                        handle(find(groessenreqinds(k,3)==celladressmat))=plot(paramat(stimnummercell{find(groessenreqinds(k,3)==celladressmat)}(n),aktivexachse),paramat(stimnummercell{find(groessenreqinds(k,3)==celladressmat)}(n),aktiveyachse),...
                            'color',farbenvec(find(groessenreqinds(k,3)==celladressmat)+1,:));
                        set(handle(find(groessenreqinds(k,3)==celladressmat)),'marker',generalmarker,'markersize',generalmarkersize,'markerfacecolor',farbenvec(find(groessenreqinds(k,3)==celladressmat)+1,:));
                    elseif gruppenfarben == 0 & gruppensymbolestatus ==1
                        handle(find(groessenreqinds(k,3)==celladressmat)+1)=plot(paramat(stimnummercell{find(groessenreqinds(k,3)==celladressmat)}(n),aktivexachse),paramat(stimnummercell{find(groessenreqinds(k,3)==celladressmat)}(n),aktiveyachse),...
                            'color',generalcolor);
                        set(handle(find(groessenreqinds(k,3)==celladressmat)),'marker',markermap{find(groessenreqinds(k,3)==celladressmat)+1},'markerfacecolor',generalcolor,'markersize',gruppenmarkersize);
                    end
                    %stimulinamen
                    %-------------
                    if filenamen==1
                        text(paramat(stimnummercell{find(groessenreqinds(k,3)==celladressmat)}(n),aktivexachse)*1.02,paramat(stimnummercell{find(groessenreqinds(k,3)==celladressmat)}(n),aktiveyachse),filenamecell{stimnummercell{find(groessenreqinds(k,3)==celladressmat)}(n)},'FontSize',dateinamenfontsize,'Color',[0 0 0]);
					end
                    
               end
               t=t+1;
            end
        end
        %legende
        %----------
        legendcell=cell(1);
        for i=1:length(handle)
            legendcell{i}=num2str(i);
        end
        handle(find(handle==0))=[];
        deletevec=[];
        deletezaehler=1;
        for i=1:length(legendcell)
            if isempty(stimnummercell{i})
                deletevec(deletezaehler)=i;
                deletezaehler=deletezaehler+1;
            end
        end
        legendcell(deletevec)=[];   
        legend(handle,legendcell);
    
    %filemodus
    %----------------    
    elseif ~isempty(aktivegruppe)
      
        if selectedstatus == 1
            answer = questdlg('Das Anzeigen von Mittelwerten nach der Gruppierungsvariable lscht vorherige Itemselektion! Fortfahren?','Achtung:','ja','nein','ja');
            if strcmp(answer,'nein')
                return
            else
                selectedstatus = 0;
            end
        end   
       
		x=zeros(size(paramat,1),1);
		for j=1:size(paramat,1)
		    x(j)=paramat(j,aktivexachse);
		end
		y=zeros(size(paramat,1),1);
		for k=1:size(paramat,1)
		    y(k)=paramat(k,aktiveyachse);
		end
        
        
        
		for wurstel1=1:size(paramat,1) 
            if nullgruppenstatus ~= 1 | paramat(wurstel1,gruppdims(aktivegruppe))~=0
                if gruppenfarben ==1 & gruppensymbolestatus == 1
                     handle(paramat(wurstel1,gruppdims(aktivegruppe))+1)=plot(x(wurstel1),y(wurstel1),'color',farbenvec(paramat(wurstel1,gruppdims(aktivegruppe))+1,:));
                     set(handle(paramat(wurstel1,gruppdims(aktivegruppe))+1),'marker',markermap{paramat(wurstel1,gruppdims(aktivegruppe))+1},'markerfacecolor',farbenvec(paramat(wurstel1,gruppdims(aktivegruppe))+1,:),'markersize',gruppenmarkersize);
                elseif gruppenfarben ==1 & gruppensymbolestatus ==0
                    handle(paramat(wurstel1,gruppdims(aktivegruppe))+1)=plot(x(wurstel1),y(wurstel1),'color',farbenvec(paramat(wurstel1,gruppdims(aktivegruppe))+1,:));
                    set(handle(paramat(wurstel1,gruppdims(aktivegruppe))+1),'marker',generalmarker,'markersize',generalmarkersize,'markerfacecolor',farbenvec(paramat(wurstel1,gruppdims(aktivegruppe))+1,:));
                elseif gruppenfarben == 0 & gruppensymbolestatus ==1
                    handle(paramat(wurstel1,gruppdims(aktivegruppe))+1)=plot(x(wurstel1),y(wurstel1),'color',generalcolor);
                    set(handle(paramat(wurstel1,gruppdims(aktivegruppe))+1),'marker',markermap{paramat(wurstel1,gruppdims(aktivegruppe))+1},'markerfacecolor',generalcolor,'markersize',gruppenmarkersize);
                end
                %stimulinamen
				%--------------------
				if filenamen==1
                    text(x(wurstel1)*1.02,y(wurstel1),filenamecell{wurstel1},'FontSize',dateinamenfontsize,'Color',[0 0 0]);
				end
                 %legende
                %----------
            end
        end
        
        legendcell=cell(1);
        for i=1:length(handle)
            legendcell{i}=num2str(i);
        end
        legendcell(find(handle==0))=[];
        handle(find(handle==0))=[];
        legend(handle,legendcell);
    end
    hold off
end 




%Gruppenmittel
%---------------

hold on
if gruppenmittelwerte==1 & gruppenvarstatus == 0  
    if selectedstatus == 0
        uiwait(errordlg('Gruppenmittel knnen erst angezeigt werden wenn entweder eine Gruppenvariable gewhlt wurde, oder Itemgruppen erstellt wurden!','Achtung:'));
        return
    %selectedmodus
    %--------------------------------
    elseif ~isempty(stimnummercell)
        for k=1:size(groessenreqinds,1)
            if groessenreqinds(k,2)>0
               mittelx=mean(paramat(stimnummercell{find(groessenreqinds(k,3)==celladressmat)},aktivexachse));
               mittely=mean(paramat(stimnummercell{find(groessenreqinds(k,3)==celladressmat)},aktiveyachse));
               ciupperx=mittelx+1.96*std(paramat(stimnummercell{find(groessenreqinds(k,3)==celladressmat)},aktivexachse))*(1/sqrt(groessenreqinds(k,2)));
               cilowerx=mittelx-1.96*std(paramat(stimnummercell{find(groessenreqinds(k,3)==celladressmat)},aktivexachse))*(1/sqrt(groessenreqinds(k,2)));
               ciuppery=mittely+1.96*std(paramat(stimnummercell{find(groessenreqinds(k,3)==celladressmat)},aktiveyachse))*(1/sqrt(groessenreqinds(k,2)));
               cilowery=mittely-1.96*std(paramat(stimnummercell{find(groessenreqinds(k,3)==celladressmat)},aktiveyachse))*(1/sqrt(groessenreqinds(k,2)));
                xrangevec=get(gca,'xlim');
				xrange=abs(diff(xrangevec));
				yrangevec=get(gca,'ylim');
				yrange=abs(diff(yrangevec));

               %Confidenzintervall:
               %--------------------
               if mittelwertfarbegroupstatus == 1 & gruppenfarben == 1
                   %x-richtung
                   %----------
                   line([ciupperx cilowerx],[mittely mittely],'linewidth',mittelwertlinewidth,'Color',farbenvec(find(groessenreqinds(k,3)==celladressmat)+1,:));
                   line([ciupperx ciupperx],[mittely-yrange*0.05 mittely+yrange*0.05],'linewidth',mittelwertlinewidth,'Color',farbenvec(find(groessenreqinds(k,3)==celladressmat)+1,:));
                   line([cilowerx cilowerx],[mittely-yrange*0.05 mittely+yrange*0.05],'linewidth',mittelwertlinewidth,'Color',farbenvec(find(groessenreqinds(k,3)==celladressmat)+1,:));
                   %y-richtung::
                   %--------------
                   line([mittelx mittelx],[ciuppery cilowery],'linewidth',mittelwertlinewidth,'Color',farbenvec(find(groessenreqinds(k,3)==celladressmat)+1,:));
                   line([mittelx-xrange*0.05 mittelx+xrange*0.05],[ciuppery ciuppery],'linewidth',mittelwertlinewidth,'Color',farbenvec(find(groessenreqinds(k,3)==celladressmat)+1,:));
                   line([mittelx-xrange*0.05 mittelx+xrange*0.05],[cilowery cilowery],'linewidth',mittelwertlinewidth,'Color',farbenvec(find(groessenreqinds(k,3)==celladressmat)+1,:));
               elseif mittelwertfarbegroupstatus == 1 & gruppenfarben == 0
                   %x-richtung
                   %----------
                   line([ciupperx cilowerx],[mittely mittely],'linewidth',mittelwertlinewidth,'Color',generalcolor);
                   line([ciupperx ciupperx],[mittely-yrange*0.05 mittely+yrange*0.05],'linewidth',mittelwertlinewidth,'Color',generalcolor);
                   line([cilowerx cilowerx],[mittely-yrange*0.05 mittely+yrange*0.05],'linewidth',mittelwertlinewidth,'Color',generalcolor);
                   %y-richtung::
                   %--------------
                   line([mittelx mittelx],[ciuppery cilowery],'linewidth',mittelwertlinewidth,'Color',generalcolor);
                   line([mittelx-xrange*0.05 mittelx+xrange*0.05],[ciuppery ciuppery],'linewidth',mittelwertlinewidth,'Color',generalcolor);
                   line([mittelx-xrange*0.05 mittelx+xrange*0.05],[cilowery cilowery],'linewidth',mittelwertlinewidth,'Color',generalcolor);
                   
               else
                   %x-richtung
                   %----------
                   line([ciupperx cilowerx],[mittely mittely],'linewidth',mittelwertlinewidth,'Color',mittelwertfarbe);
                   line([ciupperx ciupperx],[mittely-yrange*0.05 mittely+yrange*0.05],'linewidth',mittelwertlinewidth,'Color',mittelwertfarbe);
                   line([cilowerx cilowerx],[mittely-yrange*0.05 mittely+yrange*0.05],'linewidth',mittelwertlinewidth,'Color',mittelwertfarbe);
                   %y-richtung::
                   %--------------
                   line([mittelx mittelx],[ciuppery cilowery],'linewidth',mittelwertlinewidth,'Color',mittelwertfarbe);
                   line([mittelx-xrange*0.05 mittelx+xrange*0.05],[ciuppery ciuppery],'linewidth',mittelwertlinewidth,'Color',mittelwertfarbe);
                   line([mittelx-xrange*0.05 mittelx+xrange*0.05],[cilowery cilowery],'linewidth',mittelwertlinewidth,'Color',mittelwertfarbe);
               end
               
               %mittelwert
               %--------------
               if strcmp(mittelwertsymbol,'bar');
                  bar(mittelx,mittely,'group','color',mittelwertfarbe);
               
               %0000
               elseif gruppensymbolestatus == 0 & ~strcmp(mittelwertsymbol,'group') & mittelwertfarbegroupstatus == 0 & gruppenfarben == 0
                  patchhandle=plot(mittelx,mittely,'Marker',mittelwertsymbol,'markersize',mittelwertmarkersize,'markerfacecolor',mittelwertfarbe,'markeredgecolor',mittelwertfarbe); 
                  set(patchhandle,'color',mittelwertfarbe);
               %0001   
               elseif gruppensymbolestatus == 0 & ~strcmp(mittelwertsymbol,'group') & mittelwertfarbegroupstatus == 0 & gruppenfarben == 1
                  patchhandle=plot(mittelx,mittely,'Marker',mittelwertsymbol,'markersize',mittelwertmarkersize,'markerfacecolor',mittelwertfarbe,'markeredgecolor',mittelwertfarbe); 
                  set(patchhandle,'color',mittelwertfarbe);  
               %0010
               elseif gruppensymbolestatus == 0 & ~strcmp(mittelwertsymbol,'group') & mittelwertfarbegroupstatus == 1 & gruppenfarben == 0
                  patchhandle=plot(mittelx,mittely,'Marker',mittelwertsymbol,'markersize',mittelwertmarkersize,'markerfacecolor',generalcolor,'markeredgecolor',generalcolor); 
                  set(patchhandle,'color',generalcolor); 
               %0011
               elseif gruppensymbolestatus == 0 & ~strcmp(mittelwertsymbol,'group') & mittelwertfarbegroupstatus == 1 & gruppenfarben == 1
                  patchhandle=plot(mittelx,mittely,'Marker',mittelwertsymbol,'markersize',mittelwertmarkersize,'markerfacecolor',farbenvec(find(groessenreqinds(k,3)==celladressmat)+1,:),'markeredgecolor',farbenvec(find(groessenreqinds(k,3)==celladressmat)+1,:)); 
                  set(patchhandle,'color',farbenvec(find(groessenreqinds(k,3)==celladressmat)+1,:)); 
               %0100
               elseif gruppensymbolestatus == 0 & strcmp(mittelwertsymbol,'group') & mittelwertfarbegroupstatus == 0 & gruppenfarben == 0
                  patchhandle=plot(mittelx,mittely,'Marker',generalmarker,'markersize',mittelwertmarkersize,'markerfacecolor',mittelwertfarbe,'markeredgecolor',mittelwertfarbe); 
                  set(patchhandle,'color',mittelwertfarbe); 
               %0101
               elseif gruppensymbolestatus == 0 & strcmp(mittelwertsymbol,'group') & mittelwertfarbegroupstatus == 0 & gruppenfarben == 1
                  patchhandle=plot(mittelx,mittely,'Marker',generalmarker,'markersize',mittelwertmarkersize,'markerfacecolor',mittelwertfarbe,'markeredgecolor',mittelwertfarbe); 
                  set(patchhandle,'color',mittelwertfarbe);
               %0110
               elseif gruppensymbolestatus == 0 & strcmp(mittelwertsymbol,'group') & mittelwertfarbegroupstatus == 1 & gruppenfarben == 0 %how stupid can you get???
                  patchhandle=plot(mittelx,mittely,'Marker',generalmarker,'markersize',mittelwertmarkersize,'markerfacecolor',generalcolor,'markeredgecolor',generalcolor); 
                  set(patchhandle,'color',farbenvec(find(groessenreqinds(k,3)==celladressmat)+1,:)); 
               %0111   
               elseif gruppensymbolestatus == 0 & strcmp(mittelwertsymbol,'group') & mittelwertfarbegroupstatus == 1 & gruppenfarben == 1
                  patchhandle=plot(mittelx,mittely,'Marker',generalmarker,'markersize',mittelwertmarkersize,'markerfacecolor',farbenvec(find(groessenreqinds(k,3)==celladressmat)+1,:),'markeredgecolor',farbenvec(find(groessenreqinds(k,3)==celladressmat)+1,:)); 
                  set(patchhandle,'color',farbenvec(find(groessenreqinds(k,3)==celladressmat)+1,:)); 
               %1000 
               elseif gruppensymbolestatus == 1 & ~strcmp(mittelwertsymbol,'group') & mittelwertfarbegroupstatus == 0 & gruppenfarben == 0
                  patchhandle=plot(mittelx,mittely,'Marker',mittelwertsymbol,'markersize',mittelwertmarkersize,'markerfacecolor',mittelwertfarbe,'markeredgecolor',mittelwertfarbe); 
                  set(patchhandle,'color',mittelwertfarbe);
               %1001
               elseif gruppensymbolestatus == 1 & ~strcmp(mittelwertsymbol,'group') & mittelwertfarbegroupstatus == 0 & gruppenfarben == 1
                  patchhandle=plot(mittelx,mittely,'Marker',mittelwertsymbol,'markersize',mittelwertmarkersize,'markerfacecolor',mittelwertfarbe,'markeredgecolor',mittelwertfarbe); 
                  set(patchhandle,'color',mittelwertfarbe); 
               %1010
               elseif gruppensymbolestatus == 1 & strcmp(mittelwertsymbol,'group') & mittelwertfarbegroupstatus == 1 & gruppenfarben == 0
                  patchhandle=plot(mittelx,mittely,'Marker',markermap{k+1},'markersize',mittelwertmarkersize,'markerfacecolor',generalcolor,'markeredgecolor',generalcolor); 
                  set(patchhandle,'color',generalcolor);
               %1011   
               elseif gruppensymbolestatus == 1 & ~strcmp(mittelwertsymbol,'group') & mittelwertfarbegroupstatus == 1 & gruppenfarben == 1
                  patchhandle=plot(mittelx,mittely,'Marker',mittelwertsymbol,'markersize',mittelwertmarkersize,'markerfacecolor',farbenvec(find(groessenreqinds(k,3)==celladressmat)+1,:),'markeredgecolor',farbenvec(find(groessenreqinds(k,3)==celladressmat)+1,:)); 
                  set(patchhandle,'color',farbenvec(find(groessenreqinds(k,3)==celladressmat)+1,:));
               %1100
               elseif gruppensymbolestatus == 1 & strcmp(mittelwertsymbol,'group') & mittelwertfarbegroupstatus == 0 & gruppenfarben == 0
                  patchhandle=plot(mittelx,mittely,'Marker',markermap{k+1},'markersize',mittelwertmarkersize,'markerfacecolor',mittelwertfarbe,'markeredgecolor',mittelwertfarbe); 
                  set(patchhandle,'color',mittelwertfarbe);
               %1101
               elseif gruppensymbolestatus == 0 & strcmp(mittelwertsymbol,'group') & mittelwertfarbegroupstatus == 1 & gruppenfarben == 1
                  patchhandle=plot(mittelx,mittely,'Marker',generalmarker,'markersize',mittelwertmarkersize,'markerfacecolor',farbenvec(find(groessenreqinds(k,3)==celladressmat)+1,:),'markeredgecolor',farbenvec(find(groessenreqinds(k,3)==celladressmat)+1,:)); 
                  set(patchhandle,'color',farbenvec(find(groessenreqinds(k,3)==celladressmat)+1,:)); 
               %1111
               elseif gruppensymbolestatus == 1 & strcmp(mittelwertsymbol,'group') & mittelwertfarbegroupstatus == 1 & gruppenfarben == 1
                  patchhandle=plot(mittelx,mittely,'Marker',markermap{k+1},'markersize',mittelwertmarkersize,'markerfacecolor',farbenvec(find(groessenreqinds(k,3)==celladressmat)+1,:),'markeredgecolor',farbenvec(find(groessenreqinds(k,3)==celladressmat)+1,:)); 
                  set(patchhandle,'color',farbenvec(find(groessenreqinds(k,3)==celladressmat)+1,:)); 
                 
               end
           end
        end
    end
    
%filemodus
%-------------
elseif gruppenvarstatus == 1 & gruppenmittelwerte == 1
    
    if selectedstatus == 1
        answer = questdlg('Das Anzeigen von Mittelwerten nach der Gruppierungsvariable lscht vorherige Itemselektion! Fortfahren?','Achtung:','ja','nein','ja');
        if strcmp(answer,'nein')
            return
        else
            selectedstatus = 0;
        end
    end
    
    element=[];
    elementzaehler=1;
    element(1)=paramat(1,gruppdims(aktivegruppe));
    restmat=paramat(:,gruppdims(aktivegruppe));
    schrittzaehler=2;
    while 1
        elementindices=find(paramat(:,gruppdims(aktivegruppe))==paramat(elementzaehler,gruppdims(aktivegruppe)));
        restmat(elementindices)=0;
        nextelementindices=find(restmat);
        if ~isempty(nextelementindices)
            elementzaehler=nextelementindices(1);
            element(schrittzaehler)=paramat(nextelementindices(1),gruppdims(aktivegruppe));
            schrittzaehler=schrittzaehler+1;
        else
            break
        end
    end  
    stimnummercell=cell(length(element),1);
    restmat=paramat(:,gruppdims(aktivegruppe));
    for hanswurst=1:size(stimnummercell,1)
        stimnummercell{hanswurst,1}=find(restmat==element(hanswurst));
    end
    for depp1=1:size(stimnummercell,1)
        
        if nullgruppenstatus ~= 1 | element(depp1)~=0
                mittelx=mean(paramat(stimnummercell{depp1},aktivexachse));
                mittely=mean(paramat(stimnummercell{depp1},aktiveyachse));
                ciupperx=mittelx+1.96*std(paramat(stimnummercell{depp1},aktivexachse))*(1/sqrt(length(stimnummercell{depp1})));
                cilowerx=mittelx-1.96*std(paramat(stimnummercell{depp1},aktivexachse))*(1/sqrt(length(stimnummercell{depp1})));
                ciuppery=mittely+1.96*std(paramat(stimnummercell{depp1},aktiveyachse))*(1/sqrt(length(stimnummercell{depp1})));
                cilowery=mittely-1.96*std(paramat(stimnummercell{depp1},aktiveyachse))*(1/sqrt(length(stimnummercell{depp1})));
                xrangevec=get(gca,'xlim');
				xrange=abs(diff(xrangevec));
				yrangevec=get(gca,'ylim');
				yrange=abs(diff(yrangevec));
              %Confidenzintervall:
              if mittelwertfarbegroupstatus == 1 & gruppenfarben == 1
                   %x-richtung
                   %----------
                   line([ciupperx cilowerx],[mittely mittely],'Color',farbenvec(element(depp1)+1,:),'linewidth',mittelwertlinewidth);
                   line([ciupperx ciupperx],[mittely-yrange*0.05 mittely+yrange*0.05],'Color',farbenvec(element(depp1)+1,:),'linewidth',mittelwertlinewidth);
                   line([cilowerx cilowerx],[mittely-yrange*0.05 mittely+yrange*0.05],'Color',farbenvec(element(depp1)+1,:),'linewidth',mittelwertlinewidth);
                   %y-richtung::
                   %--------------
                   line([mittelx mittelx],[ciuppery cilowery],'Color',farbenvec(element(depp1)+1,:),'linewidth',mittelwertlinewidth);
                   line([mittelx-xrange*0.05 mittelx+xrange*0.05],[ciuppery ciuppery],'Color',farbenvec(element(depp1)+1,:),'linewidth',mittelwertlinewidth);
                   line([mittelx-xrange*0.05 mittelx+xrange*0.05],[cilowery cilowery],'Color',farbenvec(element(depp1)+1,:),'linewidth',mittelwertlinewidth);
                   
               elseif mittelwertfarbegroupstatus == 1 & gruppenfarben == 0
                    %x-richtung
                   %----------
                   line([ciupperx cilowerx],[mittely mittely],'Color',generalcolor,'linewidth',mittelwertlinewidth);
                   line([ciupperx ciupperx],[mittely-yrange*0.05 mittely+yrange*0.05],'Color',generalcolor,'linewidth',mittelwertlinewidth);
                   line([cilowerx cilowerx],[mittely-yrange*0.05 mittely+yrange*0.05],'Color',generalcolor,'linewidth',mittelwertlinewidth);
                   %y-richtung::
                   %--------------
                   line([mittelx mittelx],[ciuppery cilowery],'Color',generalcolor,'linewidth',mittelwertlinewidth);
                   line([mittelx-xrange*0.05 mittelx+xrange*0.05],[ciuppery ciuppery],'Color',generalcolor,'linewidth',mittelwertlinewidth);
                   line([mittelx-xrange*0.05 mittelx+xrange*0.05],[cilowery cilowery],'Color',generalcolor,'linewidth',mittelwertlinewidth);
               else
                       %x-richtung
                   %----------
                   line([ciupperx cilowerx],[mittely mittely],'Color',mittelwertfarbe,'linewidth',mittelwertlinewidth);
                   line([ciupperx ciupperx],[mittely-yrange*0.05 mittely+yrange*0.05],'Color',mittelwertfarbe,'linewidth',mittelwertlinewidth);
                   line([cilowerx cilowerx],[mittely-yrange*0.05 mittely+yrange*0.05],'Color',mittelwertfarbe,'linewidth',mittelwertlinewidth);
                   %y-richtung::
                   %--------------
                   line([mittelx mittelx],[ciuppery cilowery],'Color',mittelwertfarbe,'linewidth',mittelwertlinewidth);
                   line([mittelx-xrange*0.05 mittelx+xrange*0.05],[ciuppery ciuppery],'Color',mittelwertfarbe,'linewidth',mittelwertlinewidth);
                   line([mittelx-xrange*0.05 mittelx+xrange*0.05],[cilowery cilowery],'Color',mittelwertfarbe,'linewidth',mittelwertlinewidth);
              
               end
               
               %mittelwert
               %--------------
               if strcmp(mittelwertsymbol,'bar');
                  bar(mittelx,mittely,'group','color',mittelwertfarbe);
               
               %0000
               elseif gruppensymbolestatus == 0 & ~strcmp(mittelwertsymbol,'group') & mittelwertfarbegroupstatus == 0 & gruppenfarben == 0
                  patchhandle=plot(mittelx,mittely,'Marker',mittelwertsymbol,'markersize',mittelwertmarkersize,'markerfacecolor',mittelwertfarbe,'markeredgecolor',mittelwertfarbe); 
                  set(patchhandle,'color',mittelwertfarbe);
               %0001   
               elseif gruppensymbolestatus == 0 & ~strcmp(mittelwertsymbol,'group') & mittelwertfarbegroupstatus == 0 & gruppenfarben == 1
                  patchhandle=plot(mittelx,mittely,'Marker',mittelwertsymbol,'markersize',mittelwertmarkersize,'markerfacecolor',mittelwertfarbe,'markeredgecolor',mittelwertfarbe); 
                  set(patchhandle,'color',mittelwertfarbe);  
               %0010
               elseif gruppensymbolestatus == 0 & ~strcmp(mittelwertsymbol,'group') & mittelwertfarbegroupstatus == 1 & gruppenfarben == 0
                  patchhandle=plot(mittelx,mittely,'Marker',mittelwertsymbol,'markersize',mittelwertmarkersize,'markerfacecolor',generalcolor,'markeredgecolor',generalcolor); 
                  set(patchhandle,'color',generalcolor); 
               %0011
               elseif gruppensymbolestatus == 0 & ~strcmp(mittelwertsymbol,'group') & mittelwertfarbegroupstatus == 1 & gruppenfarben == 1
                  patchhandle=plot(mittelx,mittely,'Marker',mittelwertsymbol,'markersize',mittelwertmarkersize,'markerfacecolor',farbenvec(element(depp1)+1,:),'markeredgecolor',farbenvec(element(depp1)+1,:)); 
                  set(patchhandle,'color',farbenvec(element(depp1)+1,:)); 
               %0100
               elseif gruppensymbolestatus == 0 & strcmp(mittelwertsymbol,'group') & mittelwertfarbegroupstatus == 0 & gruppenfarben == 0
                  patchhandle=plot(mittelx,mittely,'Marker',generalmarker,'markersize',mittelwertmarkersize,'markerfacecolor',mittelwertfarbe,'markeredgecolor',mittelwertfarbe); 
                  set(patchhandle,'color',mittelwertfarbe); 
               %0101
               elseif gruppensymbolestatus == 0 & strcmp(mittelwertsymbol,'group') & mittelwertfarbegroupstatus == 0 & gruppenfarben == 1
                  patchhandle=plot(mittelx,mittely,'Marker',generalmarker,'markersize',mittelwertmarkersize,'markerfacecolor',mittelwertfarbe,'markeredgecolor',mittelwertfarbe); 
                  set(patchhandle,'color',mittelwertfarbe);
               %0110
               elseif gruppensymbolestatus == 0 & strcmp(mittelwertsymbol,'group') & mittelwertfarbegroupstatus == 1 & gruppenfarben == 0 %how stupid can you get???
                  patchhandle=plot(mittelx,mittely,'Marker',generalmarker,'markersize',mittelwertmarkersize,'markerfacecolor',generalcolor,'markeredgecolor',generalcolor); 
                  set(patchhandle,'color',farbenvec(element(depp1)+1,:)); 
               %0111   
               elseif gruppensymbolestatus == 0 & strcmp(mittelwertsymbol,'group') & mittelwertfarbegroupstatus == 1 & gruppenfarben == 1
                  patchhandle=plot(mittelx,mittely,'Marker',generalmarker,'markersize',mittelwertmarkersize,'markerfacecolor',farbenvec(element(depp1)+1,:),'markeredgecolor',farbenvec(element(depp1)+1,:)); 
                  set(patchhandle,'color',farbenvec(element(depp1)+1,:)); 
               %1000 
               elseif gruppensymbolestatus == 1 & ~strcmp(mittelwertsymbol,'group') & mittelwertfarbegroupstatus == 0 & gruppenfarben == 0
                  patchhandle=plot(mittelx,mittely,'Marker',mittelwertsymbol,'markersize',mittelwertmarkersize,'markerfacecolor',mittelwertfarbe,'markeredgecolor',mittelwertfarbe); 
                  set(patchhandle,'color',mittelwertfarbe);
               %1001
               elseif gruppensymbolestatus == 1 & ~strcmp(mittelwertsymbol,'group') & mittelwertfarbegroupstatus == 0 & gruppenfarben == 1
                  patchhandle=plot(mittelx,mittely,'Marker',mittelwertsymbol,'markersize',mittelwertmarkersize,'markerfacecolor',mittelwertfarbe,'markeredgecolor',mittelwertfarbe); 
                  set(patchhandle,'color',mittelwertfarbe); 
               %1010
               elseif gruppensymbolestatus == 1 & strcmp(mittelwertsymbol,'group') & mittelwertfarbegroupstatus == 1 & gruppenfarben == 0
                  patchhandle=plot(mittelx,mittely,'Marker',markermap{element(depp1)+1},'markersize',mittelwertmarkersize,'markerfacecolor',generalcolor,'markeredgecolor',generalcolor); 
                  set(patchhandle,'color',generalcolor);
               %1011   
               elseif gruppensymbolestatus == 1 & ~strcmp(mittelwertsymbol,'group') & mittelwertfarbegroupstatus == 1 & gruppenfarben == 1
                  patchhandle=plot(mittelx,mittely,'Marker',mittelwertsymbol,'markersize',mittelwertmarkersize,'markerfacecolor',farbenvec(element(depp1)+1,:),'markeredgecolor',farbenvec(element(depp1)+1,:)); 
                  set(patchhandle,'color',farbenvec(element(depp1)+1,:));
               %1100
               elseif gruppensymbolestatus == 1 & strcmp(mittelwertsymbol,'group') & mittelwertfarbegroupstatus == 0 & gruppenfarben == 0
                  patchhandle=plot(mittelx,mittely,'Marker',markermap{element(depp1)+1},'markersize',mittelwertmarkersize,'markerfacecolor',mittelwertfarbe,'markeredgecolor',mittelwertfarbe); 
                  set(patchhandle,'color',mittelwertfarbe);
               %1101
               elseif gruppensymbolestatus == 1 & strcmp(mittelwertsymbol,'group') & mittelwertfarbegroupstatus == 0 & gruppenfarben == 1
                  patchhandle=plot(mittelx,mittely,'Marker',markermap{element(depp1)+1},'markersize',mittelwertmarkersize,'markerfacecolor',mittelwertfarbe,'markeredgecolor',mittelwertfarbe); 
                  set(patchhandle,'color',farbenvec(element(depp1)+1,:)); 
               %1111
               elseif gruppensymbolestatus == 1 & strcmp(mittelwertsymbol,'group') & mittelwertfarbegroupstatus == 1 & gruppenfarben == 1
                  patchhandle=plot(mittelx,mittely,'Marker',markermap{element(depp1)+1},'markersize',mittelwertmarkersize,'markerfacecolor',farbenvec(element(depp1)+1,:),'markeredgecolor',farbenvec(element(depp1)+1,:)); 
                  set(patchhandle,'color',farbenvec(element(depp1)+1,:)); 
                 
               end 
           end
   end
end 
hold off
handle=[];




   


%Achsenbeschriftung
%--------------------------
hold on
xlabel(dim{aktivexachse+1},'FontSize',16,'Color',[0 0 0]);
ylabel(dim{aktiveyachse+1},'FontSize',16,'Color',[0 0 0]);
if zachsestatus == 1
    zlabel(dim{aktivezachse+1},'FontSize',16);
end
hold off;


%zellgrenzen
%-----------------
zellgrenzenradio = findobj('Tag','zellgrenzenradio');
zellgrenzen = get(zellgrenzenradio,'Value');
if zellgrenzen==1
    hold on
    if ~isempty(absolutreqs{1,1})
        
        for k=1:size(absolutreqs,1)
            if strcmp(dim{aktivexachse+1},absolutreqs{k,4})
                xpairs=[absolutreqs{k,2} absolutreqs{k,2}];
                ypairs=[min(get(gca,'YLim')) max(get(gca,'YLim'))];
                line(xpairs,ypairs);
             
            elseif strcmp(dim{aktiveyachse+1},absolutreqs{k,4})
                xpairs=[min(get(gca,'XLim')) max(get(gca,'XLim'))];
                ypairs=[absolutreqs{k,2} absolutreqs{k,2}];
                line(xpairs,ypairs);
             % reqnumber; absolutWert ; celladdress ; dimension; operator;
            end
        end
    end
    hold off
end



return
