clear all;

%Variablen
%------------------------------
global selectfilemonitor zachsestatus element gruppcell faktorstring anzahlfaktoren stufenvec aktiverfaktor zielmat cellstr vergleichecell dim anzahldims anzahlstimuli paramat operatorcell filenamecell filenamestatus stimnummercell
%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      
stufenvec=[];
faktorstring = cell(1);
anzahlfaktoren = 1;
aktiverfaktor = 1;
cellstr=cell(1);
cellstr{1}='cell1';
vergleichecell=cell(1);
operatorcell=cell(6,1);
operatorcell{1}=' = ';operatorcell{2}=' > ';operatorcell{3}=' < ';operatorcell{4}='n#=';operatorcell{5}='|>|';operatorcell{6}='|<|';operatorcell{7}='|=|';
alphacell=cell(2,1);alphacell{1}='0.1000';alphacell{2}='0.0500';alphacell{3}='0.0010';alphacell{4}='0.0005';
gruppcell=cell(1);
gruppdims=[];
paramat=zeros(1);
filenamecell=cell(1);
zachsestatus=0;
dim = cell(1);
anzahldims = 1;   
anzahlstimuli = 1;

%Uni
screensize=get(0,'ScreenSize');

selectitemsfigure = figure('Color',[0.8 0.8 0.8], ...
    'Units','normalized',...
    'Name','Selectitems', ...
    'Menubar','figure',...
	'Position',[0.1328    0.74   0.5430    0.1855], ...
	'Tag','selectitemsfigure',...
    'NumberTitle','off');

f = uimenu ('Parent',selectitemsfigure,'Label','File');
    uimenu(f,'Label','bedingungen laden','Callback','[vergleichecell]=loadselitemsfile(vergleichecell);');
    uimenu(f,'Label','bedingungen speichern','Callback','[vergleichecell]=saveselitemsfile(vergleichecell);');
   
b = uicontrol('Parent',selectitemsfigure, ...
    'Units','normalized',...
	'BackgroundColor',[0.9 0.8 0.3], ...
    'ForegroundColor',[0.9 0.8 0.3], ...
	'Position',[0 0  1 1], ...
	'Style','frame', ...
	'Tag','Frame1');

resetbutton = uicontrol('Parent',selectitemsfigure, ...
    'Units','normalized',...
	'Position',[0.7885 0.85 0.1923 0.0968], ...
    'Callback','resetallsel',...
    'String','reset',...
	'Style','pushbutton', ...
	'Tag','Frame1');

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%



schaubild = figure('Name','Selectitems', ...
    'Units','normalized',...
    'Menubar','figure',...
	'Position',[0.1328    0.0313    0.5430    0.64 ], ...
    'Color',[0.831 0.815 0.784],...
	'Tag','schaubild',...
    'NumberTitle','off');

schaubildaxes = axes('Position',[0.1 0.1 0.78 0.7],...
    'Units','normalized',...
    'parent',schaubild);

AXIS([0 1 0 1])

xachsenlabel = uicontrol('Parent',schaubild, ...
    'Units','normalized',...
	'Position',[0.05   0.94   0.02   0.03], ...
	'String','X:', ...
    'FontUnits','normalized',...
    'FontSize',0.8,...
    'Style','text',...
    'Enable','on',...
	'Tag','xachsenlabel');

xachsenpopup = uicontrol('Parent',schaubild, ...
    'Units','normalized',...
	'Position',[0.091   0.95    0.23    0.03], ...
    'BackgroundColor',[1 1 1], ...
	'String',['x-achse';'x-achse'], ...
    'Style','popupmenu',...
    'FontUnits','normalized',...
    'FontSize',0.8,...
    'Enable','on',...
    'Callback','',...
	'Tag','xachsenpopup');

gruppenradio = uicontrol('Parent',schaubild, ...
    'Units','normalized',...
    'FontUnits','normalized',...
    'FontSize',0.8,...
	'Position',[0.05   0.84    0.23    0.03], ...
	'String','Gruppierungsvariable:', ...
    'Style','radio',...
    'Enable','on',...
    'Callback','enablegruppenpopup;',...
	'Tag','gruppenradio');

gruppenpopup = uicontrol('Parent',schaubild, ...
    'Units','normalized',...
	'Position',[0.371   0.84    0.23    0.03], ...
    'BackgroundColor',[1 1 1], ...
	'String','Gruppe', ...
    'Style','popupmenu',...
    'FontUnits','normalized',...
    'FontSize',0.8,...
    'Enable','off',...
    'Callback','',...
	'Tag','gruppenpopup');

ttestbutton = uicontrol('Parent',schaubild, ...
    'Units','normalized',...
	'Position',[0.281   0.84    0.07    0.03], ...
	'String','t-test', ...
    'Style','pushbutton',...
    'Enable','off',...
    'FontUnits','normalized',...
    'FontSize',0.8,...
    'Callback','ttestforgroups(paramat)',...
	'Tag','ttestbutton');


formatlabel = uicontrol('Parent',schaubild, ...
    'Units','normalized',...
	'Position',[0.9 0.54 0.08 0.03], ...
	'String','Mean as:', ...
    'Style','text',...
    'Enable','on',...
    'FontUnits','normalized',...
    'FontSize',0.8,...
    'HorizontalAlignment','left',...
    'Callback','enablegruppenpopup;',...
	'Tag','formatlabel');

formatpopup = uicontrol('Parent',schaubild, ...
    'Units','normalized',...
	'Position',[0.9 0.5 0.08 0.03], ...
    'BackgroundColor',[1 1 1], ...
	'String',['Punkt';'Bar  '],...
    'Style','popupmenu',...
    'FontUnits','normalized',...
    'FontSize',0.8,...
    'Enable','on',...
    'Callback','',...
	'Tag','formatpopup');


farblabel = uicontrol('Parent',schaubild, ...
    'Units','normalized',...
	'Position',[0.9 0.44 0.08 0.03], ...
	'String','Farbe:', ...
    'Style','text',...
    'HorizontalAlignment','left',...
    'FontUnits','normalized',...
    'FontSize',0.8,...
    'Enable','on',...
    'Callback','enablegruppenpopup;',...
	'Tag','formatlabel');

farbpopup = uicontrol('Parent',schaubild, ...
    'Units','normalized',...
	'Position',[0.9 0.4 0.08 0.03], ...
    'BackgroundColor',[1 1 1], ...
	'String',['rot ';'grn';'blau';'gelb'],...
    'Style','popupmenu',...
    'FontUnits','normalized',...
    'FontSize',0.8,...
    'Enable','on',...
    'Callback','',...
	'Tag','formatpopup');

rotate3dradio = uicontrol('Parent',schaubild, ...
    'Units','normalized',...
	'Position',[0.9 0.24 0.08 0.03], ...
	'String','rotate',...
    'Style','pushbutton',...
    'FontUnits','normalized',...
    'FontSize',0.8,...
    'Enable','on',...
    'Callback','rotate3d;',...
	'Tag','rotate3dradio');

griddradio = uicontrol('Parent',schaubild, ...
    'Units','normalized',...
	'Position',[0.9 0.3 0.08 0.03], ...
	'String','grid',...
    'Style','pushbutton',...
    'FontUnits','normalized',...
    'FontSize',0.8,...
    'Enable','on',...
    'Callback','grid;',...
	'Tag','rotate3dradio');

yachsenlabel = uicontrol('Parent',schaubild, ...
    'Units','normalized',...
	'Position',[0.33   0.94   0.03    0.03], ...
	'String','Y:', ...
    'FontUnits','normalized',...
    'FontSize',0.8,...
    'Style','text',...
    'Enable','on',...
	'Tag','yachsenlabel');

yachsenpopup = uicontrol('Parent',schaubild, ...
    'Units','normalized',...
	'Position',[0.371   0.95   0.23    0.03], ...
    'BackgroundColor',[1 1 1], ...
	'String','y-achse', ...
    'FontUnits','normalized',...
    'FontSize',0.8,...
    'Style','popupmenu',...
    'Enable','off',...
    'Callback','',...
	'Tag','yachsenpopup');

zachsenradio = uicontrol('Parent',schaubild, ...
    'Units','normalized',...
	'Position',[0.63   0.945   0.1    0.03], ...
	'String','Z:', ...
    'Style','radio',...
    'FontUnits','normalized',...
    'FontSize',0.8,...
    'Callback','toggle3d;',...
    'Enable','on',...
	'Tag','yachsenlabel');

zachsenpopup = uicontrol('Parent',schaubild, ...
	'Units','normalized', ...
	'Position',[0.701   0.95   0.13    0.03], ...
    'BackgroundColor',[1 1 1], ...
	'String','z-achse', ...
    'Style','popupmenu',...
    'FontUnits','normalized',...
    'FontSize',0.8,...
    'Enable','off',...
    'Callback','',...
	'Tag','zachsenpopup');

drawbutton = uicontrol('Parent',schaubild, ...
	'Units','normalized', ...
	'Position',[0.90   0.84    0.08    0.15], ...
	'String','draw', ...
    'FontUnits','normalized',...
    'FontSize',0.1,...
    'Style','pushbutton',...
    'Enable','off',...
    'Callback','seldraw;',...
	'Tag','drawbutton');

dateinamenradio = uicontrol('Parent',schaubild, ...
	'Units','normalized', ...
	'Position',[0.05   0.89    0.23    0.03], ...
	'String','Dateinamen anzeigen', ...
    'Style','radiobutton',...
    'Enable','on',...
    'FontUnits','normalized',...
    'FontSize',0.8,...
    'Callback','',...
	'Tag','dateinamenradio');

zellgrenzenradio = uicontrol('Parent',schaubild, ...
	'Units','normalized', ...
	'Position',[0.371   0.89    0.23    0.03], ...
	'String','Zellgrenzen anzeigen', ...
    'Style','radiobutton',...
    'Enable','on',...
    'FontUnits','normalized',...
    'FontSize',0.8,...
    'Callback','',...
	'Tag','zellgrenzenradio');

gruppenmittelwerteradio = uicontrol('Parent',schaubild, ...
	'Units','normalized', ...
	'Position',[0.63   0.89   0.25    0.03], ...
	'String','Gruppenmittelwerte anzeigen', ...
    'Style','radiobutton',...
    'Enable','on',...
    'FontUnits','normalized',...
    'FontSize',0.8,...
    'Callback','',...
	'Tag','gruppenmittelwerteradio');

gruppenfarbenradio = uicontrol('Parent',schaubild, ...
	'Units','normalized', ...
	'Position',[0.63   0.84    0.25    0.03], ...
	'String','Gruppenfarben anzeigen', ...
    'Style','radiobutton',...
    'Enable','on',...
    'FontUnits','normalized',...
    'FontSize',0.8,...
    'Callback','enablegruppenfarben',...
	'Tag','gruppenfarbenradio');

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


addbutton = uicontrol('Parent',selectitemsfigure, ...
	'Units','normalized', ...
	'Position',[0.4808    0.2258    0.0481    0.2903], ...
	'String','-->', ...
    'Enable','off',...
    'FontUnits','normalized',...
    'FontSize',0.2,...
    'Callback','[vergleichecell]=regreq(cellstr,stufenvec,vergleichecell);',...
	'Tag','addbutton');

faktorenanzahledit = uicontrol('Parent',selectitemsfigure, ...
	'Units','normalized', ...
	'BackgroundColor',[1 1 1], ...
	'Position',[0.0288   0.60    0.1079    0.0994], ...
	'Style','edit', ...
    'String','',...
    'FontUnits','normalized',...
    'FontSize',0.8,...
    'Callback','[faktorstring]=selupdatefaktorstufenmenu;',...
	'Tag','faktorenedit');
faktorauswahl = uicontrol('Parent',selectitemsfigure, ...
	'Units','normalized', ...
	'BackgroundColor',[1 1 1], ...
	'Position',[0.1883    0.60    0.171    0.0994], ...
	'String','faktor1', ...
    'Enable','off',...
    'FontUnits','normalized',...
    'FontSize',0.8,...
	'Style','popupmenu', ...
    'Callback','[aktiverfaktor]=selsetaktiverfaktor(aktiverfaktor);',...
	'Tag','faktorauswahl', ...
	'Value',1);
stufenedit = uicontrol('Parent',selectitemsfigure, ...
	'Units','normalized', ...
	'BackgroundColor',[1 1 1], ...
	'Position',[0.3969    0.60    0.13    0.0994], ...
    'Callback','[faktorstring,stufenvec,aktiverfaktor]=selupdatestufen(faktorstring,stufenvec,aktiverfaktor);',...
    'enable','off',...
    'FontUnits','normalized',...
    'FontSize',0.8,...
	'Style','edit', ...
    'String','1',...
	'Tag','stufenedit');

label = uicontrol('Parent',selectitemsfigure, ...
	'Units','normalized', ...
	'BackgroundColor',[0.9 0.8 0.3], ...
	'HorizontalAlignment','left', ...
	'Position',[0.0216    0.4306    0.1439    0.0994], ...
	'String','Vergleiche mit a =', ...
	'Style','text', ...
    'FontUnits','normalized',...
    'FontSize',0.8,...
	'Tag','StaticText2');


vergleichemonitor = uicontrol('Parent',selectitemsfigure, ...
	'Units','normalized', ...
	'BackgroundColor',[1 1 1], ...
	'Position',[0.5577    0.2258    0.2115    0.4968], ...
	'Style','listbox', ...
    'enable','off',...
	'Tag','vergleichemonitor', ...
	'Value',1);
loeschenbutton = uicontrol('Parent',selectitemsfigure, ...
	'Units','normalized', ...
	'Position',[0.5577    0.0645    0.2115    0.0968], ...
    'enable','off',...
    'FontUnits','normalized',...
    'FontSize',0.8,...
	'String','lschen', ...
    'Callback','[vergleichecell]=reqsloeschen(vergleichecell);',...
	'Tag','loeschenbutton');
b = uicontrol('Parent',selectitemsfigure, ...
	'Units','normalized', ...
	'BackgroundColor',[0.9 0.8 0.3], ...
	'HorizontalAlignment','left', ...
	'Position',[0.0288    0.0645    0.0769    0.105], ...
	'String','Sourcfile:', ...
    'FontUnits','normalized',...
    'FontSize',0.8,...
	'Style','text', ...
	'Tag','StaticText2');
b = uicontrol('Parent',selectitemsfigure, ...
	'Units','normalized', ...
	'BackgroundColor',[1 1 1], ...
	'HorizontalAlignment','left', ...
	'Position',[0.1250    0.0645    0.1731    0.0968], ...
    'String','',...
    'FontUnits','normalized',...
    'FontSize',0.8,...
	'Style','text', ...
	'Tag','selectfilemonitor');
filewaehlenbutton = uicontrol('Parent',selectitemsfigure, ...
	'Units','normalized', ...
	'Position',[0.3269    0.0645    0.2019    0.0968], ...
	'String','whlen', ...
    'FontUnits','normalized',...
    'FontSize',0.8,...
    'Callback','[filepath,filename,dim,anzahldims,anzahlstimuli,paramat,filenamecell,filenamestatus] = selfilewaehlen(selectfilemonitor,anzahldims,anzahlstimuli,paramat,filenamecell,filenamestatus);', ...
	'Tag','filewaehlenbutton');
b = uicontrol('Parent',selectitemsfigure, ...
	'Units','normalized', ...
	'BackgroundColor',[0.9 0.8 0.3], ...
	'HorizontalAlignment','left', ...
	'Position',[0.0288    0.7097    0.1154    0.0968], ...
	'String','Faktoren:', ...
    'FontUnits','normalized',...
    'FontSize',0.8,...
	'Style','text', ...
	'Tag','StaticText2');
b = uicontrol('Parent',selectitemsfigure, ...
	'Units','normalized', ...
    'FontUnits','normalized',...
    'FontSize',0.8,...
	'BackgroundColor',[0.9 0.8 0.3], ...
	'HorizontalAlignment','left', ...
	'Position',[0.2115    0.7097    0.1462    0.0968], ...
	'String','Auswahl:', ...
	'Style','text', ...
	'Tag','StaticText2');
b = uicontrol('Parent',selectitemsfigure, ...
	'Units','normalized', ...
	'BackgroundColor',[0.9 0.8 0.3], ...
	'HorizontalAlignment','left', ...
	'Position',[0.4135    0.7097    0.0577    0.0968], ...
	'String','Stufen:', ...
    'FontUnits','normalized',...
    'FontSize',0.8,...
	'Style','text', ...
	'Tag','StaticText2');
operatorpopup = uicontrol('Parent',selectitemsfigure, ...
	'Units','normalized', ...
	'BackgroundColor',[1 1 1], ...
	'Position',[0.1923    0.2258    0.0962    0.0968], ...
	'String',operatorcell,...
    'enable','off',...
	'Style','popupmenu', ...
    'FontUnits','normalized',...
    'FontSize',0.8,...
    'Callback','updatecell2menu(cellstr,dim)',...
	'Tag','operatorpopup', ...
	'Value',1);
alphapopup = uicontrol('Parent',selectitemsfigure, ...
	'Units','normalized', ...
	'BackgroundColor',[1 1 1], ...
	'Position',[0.1923    0.4194    0.0962    0.0968], ...
	'String',alphacell,...
    'FontUnits','normalized',...
    'FontSize',0.8,...
    'enable','off',...
	'Style','popupmenu', ...
	'Tag','alphapopup', ...
	'Value',1);
auflabel = uicontrol('Parent',selectitemsfigure, ...
	'Units','normalized', ...
	'BackgroundColor',[0.9 0.8 0.3], ...
	'Position',[0.2885    0.4194    0.0385    0.0968], ...
    'enable','on',...
	'String','auf',...
    'FontUnits','normalized',...
    'FontSize',0.8,...
	'Style','text', ...
	'Tag','auflabel', ...
	'Value',1);

dimensionauswahl = uicontrol('Parent',selectitemsfigure, ...
	'Units','normalized', ...
	'BackgroundColor',[1 1 1], ...
	'Position',[0.3269    0.4194    0.1346    0.0968], ...
	'String','dimension', ...
    'FontUnits','normalized',...
    'FontSize',0.8,...
	'Style','popupmenu', ...
    'Enable','off',...
	'Tag','dimensionauswahl', ...
	'Value',1);
cell1auswahl = uicontrol('Parent',selectitemsfigure, ...
	'Units','normalized', ...
	'BackgroundColor',[1 1 1], ...
	'Position',[0.0288    0.2258    0.1442    0.0968], ...
    'FontUnits','normalized',...
    'FontSize',0.8,...
	'String','cell1', ...
	'Style','popupmenu', ... 
    'Enable','off',...
	'Tag','cell1auswahl');
cell2auswahl = uicontrol('Parent',selectitemsfigure, ...
	'Units','normalized', ...
	'BackgroundColor',[1 1 1], ...
	'Position',[0.3269    0.2258    0.1346    0.0968], ...
	'String','cell2', ...
    'FontUnits','normalized',...
    'FontSize',0.8,...
	'Style','popupmenu', ...
    'Enable','off',...
	'Tag','cell2auswahl');

haureinbutton = uicontrol('Parent',selectitemsfigure, ...
	'Units','normalized', ...
	'Position',[0.7885    0.0645    0.1923    0.0968], ...
    'enable','off',...
    'FontUnits','normalized',...
    'FontSize',0.8,...
    'Style','pushbutton',...
    'String','go!',...
	'Tag','haureinbutton', ...
    'Callback','selectitemsmain(cellstr,dim,anzahldims,anzahlstimuli,paramat,filenamecell)', ...
	'Value',1);

abbrechen = uicontrol('Parent',selectitemsfigure, ...
	'Units','normalized', ...
	'Position',[0.7885    0.1935    0.1923    0.0968], ...
    'enable','on',...
    'FontUnits','normalized',...
    'FontSize',0.8,...
    'Style','pushbutton',...
    'String','abbrechen',...
    'Callback','close',...
	'Tag','abbrechen');

statisticsradio = uicontrol('Parent',selectitemsfigure, ...
	'Units','normalized', ...
	'Position',[0.7885    0.4839    0.1923    0.0968], ...
    'BackgroundColor',[0.9 0.8 0.3], ...
    'enable','off',...
    'FontUnits','normalized',...
    'FontSize',0.8,...
    'Style','radiobutton',...
    'String','Statistik schreiben',...
    'Callback','',...
	'Tag','statisticsradio');


scenarioradio = uicontrol('Parent',selectitemsfigure, ...
	'Units','normalized', ...
	'Position',[0.7885    0.6129    0.1923    0.0968], ...
    'BackgroundColor',[0.9 0.8 0.3], ...
    'enable','off',...
    'FontUnits','normalized',...
    'FontSize',0.8,...
    'Style','radiobutton',...
    'String','Szenario schreiben',...
    'Callback','',...
	'Tag','scenarioradio');


parameterfileradio = uicontrol('Parent',selectitemsfigure, ...
	'Units','normalized', ...
	'Position',[0.7885    0.3548    0.1923    0.0968], ...
    'BackgroundColor',[0.9 0.8 0.3], ...
    'enable','off',...
    'FontUnits','normalized',...
    'FontSize',0.8,...
    'Style','radiobutton',...
    'String','Parameterfile ergnzen',...
    'Callback','',...
	'Tag','parameterfileradio');