function [outmat]=tradebrcont(filename,filepath,mode,hell,cont)
%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      

if nargin<3
    cd(pwd);
    [filename,filepath]=uigetfile('*.*','Bilddatei auswhlen:');
    mode=2;
    zielkontrast=input('Zielkontrast:');
    zielhelligkeit=input('Zielhelligkeit:');
end
if nargin==3
    % prepare datamat
    zielhelligkeitedit=findobj('tag','zielhelligkeitedit');
    zielhelligkeit=str2num(get(zielhelligkeitedit,'String'));

    zielkontrastedit=findobj('tag','zielkontrastedit');
    zielkontrast=str2num(get(zielkontrastedit,'String'));
    
end

if nargin==5
    zielhelligkeit=hell;
    zielkontrast=cont;
end



filezaehler=0;

% kein file gewhlt
if mode==0
   modefehler
   return
   
   
% directory mode   
elseif mode==11
    [savefilename,savefilepath]=uiputfile('*.txt','Ergebnisfile bestimmen:');
    savefile=[savefilepath savefilename];
    savefilehandle=fopen(savefile,'wt');
    fprintf(savefilehandle,['filename\ttot_bright\ttot_cont\tred_bright\tred_cont\tgreen_bright\tgreen_cont\tblue_bright\tblue_cont\tminb\tmaxb\n']);
	cd (filepath);
	filelist=dir(filepath);
    filelistsize=size(filelist);
    zaehler=1;
	% Schleife fr Files
    for filezaehler=3:filelistsize(1)
        try
          filename=filelist(filezaehler).name;
          paraok=0;
          fileok=0;
          fprintf(['File ',num2str(filezaehler-2),' of ',num2str(filelistsize(1)-2),'!\n']);
          while fileok==0
          picmat=imread(filename,'jpg');
          modmat=double(picmat);
          while paraok==0;
            picmat=modmat;
            fprintf('analyzing file....\n');
            [totbright,totcont,redbright,redcont,greenbright,greencont,bluebright,bluecont,minb,maxb]=pparatr(picmat);
            if totbright-zielhelligkeit<-0.06
               if maxb>254
                      fprintf('raising brightness by a lot (anticlip)....\n');
                      [modmat]=raisebranticlipstark(picmat);
                      
               else
                   fprintf('raising brightness by a lot (clip)....\n');
                      [modmat]=raisebrstark(picmat);
                      
               end
            
            elseif totbright-zielhelligkeit<-0.01
               if maxb>254
                   fprintf('raising brightness (anticlip)....\n');
                      [modmat]=raisebranticlip(picmat);
                      
               else
                   fprintf('raising brightness (clip)....\n');
                      [modmat]=raisebr(picmat);
                      
               end
                 
                 
            elseif totbright-zielhelligkeit>0.01
                if minb<1
                    fprintf('dropping brightness (anticlip)....\n');
                      [modmat]=dropbranticlip(picmat);
                      
                else
                     fprintf('dropping brightness (clip)....\n');
                      [modmat]=dropbr(picmat);
                       
                end
                
            elseif totbright-zielhelligkeit>0.06
                if minb<1
                    fprintf('dropping brightness by a lot (anticlip)....\n');
                      [modmat]=dropbranticlipstark(picmat);
                else
                    fprintf('dropping brightness by a lot (clip)....\n');
                      [modmat]=dropbrstark(picmat);
                end
             
              
              elseif totcont-zielkontrast<-0.002
                fprintf('raising contrast by a lot....\n');
               [modmat]=raisecontrstark(picmat);
               
            elseif totcont-zielkontrast<-0.001
                fprintf('raising contrast....\n');
               [modmat]=raisecontr(picmat);   
               
               
            elseif totcont-zielkontrast>0.001
                fprintf('dropping contrast....\n');
                [modmat]=dropcontr(picmat);
                
            elseif totcont-zielkontrast>0.002
                fprintf('dropping contrast by a lot....\n');
                [modmat]=dropcontrstark(picmat);
            else 
            paraok=1;
            fileok=1;
            end
        end
    end
          imwrite(uint8(modmat),filename,'jpg');
          [bildnummer,totbright,totcont,redbright,redcont,greenbright,greencont,bluebright,bluecont,minb,maxb]=ppara(filename);
          fprintf(savefilehandle,[bildnummer,'\t',num2str(totbright),'\t',num2str(totcont),'\t',num2str(redbright),'\t',num2str(redcont),'\t',num2str(greenbright),'\t',num2str(greencont),'\t',num2str(bluebright),'\t',num2str(bluecont),'\t',num2str(minb),'\t',num2str(maxb),'\n']);
      catch
          error(['error in file ',filename,'...']);
      end
      fprintf('.');
    zaehler=zaehler+1;
    if zaehler>20
        fprintf('\n');
        zaehler=0;
    end
      end
      
    
    
    
    outmat=[];
    ok
    return
     
% batchfile mode   
elseif mode==12
    [savefilename,savefilepath]=uiputfile('*.txt','Ergebnisfile bestimmen:');
    savefile=[savefilepath savefilename];
    savefilehandle=fopen(savefile,'wt');
    fprintf(savefilehandle,['filename\ttot_bright\ttot_cont\tred_bright\tred_cont\tgreen_bright\tgreen_cont\tblue_bright\tblue_cont\tminb\tmaxb\n']); 
    filemat=batchfiletomat(filename,filepath);
    filematgroessevec=size(filemat);
    filematgroesse=filematgroessevec(2);
    zaehler=0;
  for filezaehler=1:filematgroesse
      try
      fprintf(['File ',num2str(filezaehler),' of ',num2str(filematgroesse),'!\n']);
      filename=filemat{filezaehler};
      paraok=0;
      fileok=0;
      while fileok==0
      picmat=imread(filename,'jpg');
      modmat=double(picmat);
      while paraok==0;
        picmat=modmat;
        [totbright,totcont,redbright,redcont,greenbright,greencont,bluebright,bluecont,minb,maxb]=pparatr(picmat);
        if totbright-zielhelligkeit<-0.06
           if maxb>254
                  fprintf('raising brightness by a lot (anticlip)....\n');
                  [modmat]=raisebranticlipstark(picmat);
                  
           else
               fprintf('raising brightness by a lot (clip)....\n');
                  [modmat]=raisebrstark(picmat);
                  
           end
        
        elseif totbright-zielhelligkeit<-0.01
           if maxb>254
               fprintf('raising brightness (anticlip)....\n');
                  [modmat]=raisebranticlip(picmat);
                  
           else
               fprintf('raising brightness (clip)....\n');
                  [modmat]=raisebr(picmat);
                  
           end
             
             
        elseif totbright-zielhelligkeit>0.01
            if minb<1
                fprintf('dropping brightness (anticlip)....\n');
                  [modmat]=dropbranticlip(picmat);
                  
            else
                 fprintf('dropping brightness (clip)....\n');
                  [modmat]=dropbr(picmat);
                   
            end
            
        elseif totbright-zielhelligkeit>0.06
            if minb<1
                fprintf('dropping brightness by a lot (anticlip)....\n');
                  [modmat]=dropbranticlipstark(picmat);
            else
                fprintf('dropping brightness by a lot (clip)....\n');
                  [modmat]=dropbrstark(picmat);
            end
          
          elseif totcont-zielkontrast<-0.002
            fprintf('raising contrast by a lot....\n');
           [modmat]=raisecontrstark(picmat);
           
        elseif totcont-zielkontrast<-0.001
            fprintf('raising contrast....\n');
           [modmat]=raisecontr(picmat);   
           
           
        elseif totcont-zielkontrast>0.001
            fprintf('dropping contrast....\n');
            [modmat]=dropcontr(picmat);
            
        elseif totcont-zielkontrast>0.002
            fprintf('dropping contrast by a lot....\n');
            [modmat]=dropcontrstark(picmat);
        else 
        paraok=1;
        fileok=1;
        end
      end
     end
      imwrite(uint8(modmat),filename,'jpg');
      [bildnummer,totbright,totcont,redbright,redcont,greenbright,greencont,bluebright,bluecont,minb,maxb]=ppara(filename);
      fprintf(savefilehandle,[bildnummer,'\t',num2str(totbright),'\t',num2str(totcont),'\t',num2str(redbright),'\t',num2str(redcont),'\t',num2str(greenbright),'\t',num2str(greencont),'\t',num2str(bluebright),'\t',num2str(bluecont),'\t',num2str(minb),'\t',num2str(maxb),'\n']);
     catch
          error(['error in file ',filename,'...']);
      end   
      
      
      
    fprintf('.');
    zaehler=zaehler+1;
    if zaehler>20
        fprintf('\n');
        zaehler=0;
    end
    
    
    end
    fclose(savefilehandle);
    outmat=[];
    return
   
      
% single file mode   
elseif mode==2
    filename=[filepath,filename];
     paraok=0;
      fileok=0;
      while fileok==0
      picmat=imread(filename,'jpg');
      modmat=double(picmat);
      while paraok==0;
        picmat=modmat;
        [totbright,totcont,redbright,redcont,greenbright,greencont,bluebright,bluecont,minb,maxb]=pparatr(picmat);
         if totbright-zielhelligkeit<-0.06
           if maxb>254
                  fprintf('raising brightness by a lot (anticlip)....\n');
                  [modmat]=raisebranticlipstark(picmat);
                  
           else
               fprintf('raising brightness by a lot (clip)....\n');
                  [modmat]=raisebrstark(picmat);
                  
           end
        
        elseif totbright-zielhelligkeit<-0.01
           if maxb>254
               fprintf('raising brightness (anticlip)....\n');
                  [modmat]=raisebranticlip(picmat);
                  
           else
               fprintf('raising brightness (clip)....\n');
                  [modmat]=raisebr(picmat);
                  
           end
             
             
        elseif totbright-zielhelligkeit>0.01
            if minb<1
                fprintf('dropping brightness (anticlip)....\n');
                  [modmat]=dropbranticlip(picmat);
                  
            else
                 fprintf('dropping brightness (clip)....\n');
                  [modmat]=dropbr(picmat);
                   
            end
            
        elseif totbright-zielhelligkeit>0.06
            if minb<1
                fprintf('dropping brightness by a lot (anticlip)....\n');
                  [modmat]=dropbranticlipstark(picmat);
            else
                fprintf('dropping brightness by a lot (clip)....\n');
                  [modmat]=dropbrstark(picmat);
            end
          
        elseif totcont-zielkontrast<-0.002
            fprintf('raising contrast by a lot....\n');
           [modmat]=raisecontrstark(picmat);
           
        elseif totcont-zielkontrast<-0.001
            fprintf('raising contrast....\n');
           [modmat]=raisecontr(picmat);   
           
           
        elseif totcont-zielkontrast>0.001
            fprintf('dropping contrast....\n');
            [modmat]=dropcontr(picmat);
            
        elseif totcont-zielkontrast>0.002
            fprintf('dropping contrast by a lot....\n');
            [modmat]=dropcontrstark(picmat);
            
            
        else 
        paraok=1;
        fileok=1;
        end
      end
      imwrite(uint8(modmat),filename,'jpg');
      outmat=uint8(modmat);
      end
      ok
      
end



return