function outstring = uigettext(instring,defaultstring,mode,menustatus)
%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      
if nargin < 4
    menustatus = 0;
end
if nargin < 1
    instring = 'Enter text in the box below and press ''ok'':';
    defaultstring = ['nrofsubjects: xx;        ';'nrofintervalls: xx;      ';'nrofchannelgroups: xx;   ';'factor1: name; deg1,deg2;'];                
end
    
if nargin < 3
    mode = 'modal';
end
F = figure('units','normalized','position',[0.4 0.4  0.4  0.4 ],'menubar','none','numbertitle','off','Name','Repeated Measures ANOVA:','tag','uigettextfigure');

if menustatus == 1
    datamenu = uimenu('label','data');
        exportdatamenuitem = uimenu(datamenu,'label','export data','Callback','exportanovadata');
    posthocmenu = uimenu('Label','posthoc');
        scheffemenuitem = uimenu('parent',posthocmenu,'label','entire family (uncorrected)','Callback','anovadraw(''scheffe'')');
        customcontrastmenuitem = uimenu('parent',posthocmenu,'label','custom contrast','Callback','anovadraw(''customcontrast'')');
        bonferroniholmmenuitem = uimenu('parent',posthocmenu,'label','BonferroniHolm','Callback','anovadraw(''bonferroniholm'')');
    graphmenu = uimenu('Label','graph');
        graphallcells = uimenu('Label','cellplot','Parent',graphmenu,'Callback','anovaplotmenu');
    windowmenu = uimenu('Label','window');
        clearwindow = uimenu('Label','clear output','Parent',windowmenu,'Callback','clearanovaoutput');
        h = uimenu('Label','rewrite anova results','Parent',windowmenu,'Callback','rewriteanovaresults(0);');
        h = uimenu('Label','rewrite anova results with SS & MS','Parent',windowmenu,'Callback','rewriteanovaresults(1);');
        h = uimenu('Label','show default menubar','Parent',windowmenu,'Callback','set(gcf,''menubar'',''figure'');');
elseif menustatus ==2
     datamenu = uimenu('label','data');
        importdatamenuitem = uimenu(datamenu,'label','import data','Callback','importanovadata');
        exportdatamenuitem = uimenu(datamenu,'label','export data','Callback','exportanovadata');
    posthocmenu = uimenu('Label','posthoc');
        scheffemenuitem = uimenu('parent',posthocmenu,'label','entire family (uncorrected)','Callback','anovadraw(''scheffe'')');
        customcontrastmenuitem = uimenu('parent',posthocmenu,'label','custom contrast','Callback','anovadraw(''customcontrast'')');
        bonferroniholmmenuitem = uimenu('parent',posthocmenu,'label','BonferroniHolm','Callback','anovadraw(''bonferroniholm'')');
    graphmenu = uimenu('Label','graph');
        graphallcells = uimenu('Label','cellplot','Parent',graphmenu,'Callback','anovaplotmenu');
    windowmenu = uimenu('Label','window');
        clearwindow = uimenu('Label','clear output','Parent',windowmenu,'Callback','clearanovaoutput');
        clearwindow = uimenu('Label','show default menubar','Parent',windowmenu,'Callback','set(gcf,''menubar'',''figure'');');
end
    
EditHandles = [];

h = uicontrol(F,'Style','Frame',...
	'tag','uigettextframe',...
    'units','normalized',...
	'Position',[0 0 1 1]);

h = uicontrol(F,'Style','Text',...
	'String',get(findobj(F,'Tag','Prompt'),'String'),...
	'FontName','times',...
	'FontWeight','Bold',...
	'FontAngle','Italic',...
	'FontSize',16,...
	'ForegroundColor','k',...
	'HorizontalAlignment','Center',...
    'tag','otherstringtext',...
    'units','normalized',...
	'Position',[0.05 0.85 0.8 0.05]);

h = uicontrol(F,'Style','Text',...
	'String',instring,...
	'HorizontalAlignment','Left',...
    'tag','instringtext',...
    'units','normalized',...
	'Position',[0.05 0.55 0.9 0.42]);

if strcmp(mode,'modal')
    
    h = uicontrol(F,'Style','Pushbutton','String','Cancel',...
	'Callback','outstring=[];uiresume;close;',...
	'Position',[220 010 070 022]);

    h = uicontrol(F,'Style','Pushbutton','String','OK',...
	'Callback','uiresume;return;',...
	'Position',[310 010 070 022],'tag','okbutton');

else
    %anova
    if menustatus
        if menustatus==2
             h = uicontrol(F,'Style','Pushbutton','String','Cancel',...
			'Callback','outstring=[];uiresume;close;',...
			'Position',[220 010 070 022]);

             h = uicontrol(F,'Style','Pushbutton','String','Set',...
			'Callback','uirmanova(''design'');',...
			'Position',[310 010 070 022],'tag','okbutton');
        else
             h = uicontrol(F,'Style','Pushbutton','String','OK',...
			'Callback','closeanova;',...
			'Position',[310 010 070 022],'tag','okbutton');
        end
    %other
    else
        h = uicontrol(F,'Style','Pushbutton','String','OK',...
		'Callback','close;',...
		'Position',[310 010 070 022],'tag','okbutton');
    end
end

if menustatus ==2
     h = uicontrol(F,'Style','Pushbutton','String','Run',...
		'Callback','uirmanova(''run'');',...
		'Position',[400 010 070 022],'tag','okbutton');
end


h = uicontrol(F,'Style','Edit',...
    'String',defaultstring,...
	'Tag','EditWindow','UserData',0,...
	'HorizontalAlignment','Left',...
	'ForegroundColor',[0 0 0],'BackgroundColor',[1 1 1],...
	'Max',2,...
	'Callback','set(gco,''UserData'',1)',...
    'tag','editfenster',...
    'units','normalized',...
	'Position',[0.05 0.12 0.9 0.4]);

hanovadata = uicontrol('tag','hanovadata','visible','off');
hfactor = uicontrol('tag','hfactor','visible','off');
hfactorp2d = uicontrol('tag','hfactorp2d','visible','off');
hvalidfactor = uicontrol('tag','hvalidfactor','visible','off');
hvalidbetweenfactor = uicontrol('tag','hvalidbetweenfactor','visible','off');
hresults = uicontrol('tag','hresults','visible','off');
hTotQS = uicontrol('tag','hTotQS','visible','off');
hSubjectQS = uicontrol('tag','hSubjectQS','visible','off');
hTotDf = uicontrol('tag','hTotDf','visible','off');
hSubjectDf= uicontrol('tag','hSubjectDf','visible','off');

if strcmp(mode,'modal')
    uiwait;
    editfenster = findobj('tag','editfenster');
    outstring = get(editfenster,'string');
else
    editfenster = findobj('tag','editfenster');
    outstring = get(editfenster,'string');
end





return


