function [x,y,z]=vertexmat2sphere(vseg,hseg,displaystatus)
%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      

if nargin<3;displaystatus=1;end
if nargin<1;vseg=100;hseg=200;end
global vertexmat patchmat x y z
if isempty(vertexmat)
    answer=questdlg('Do you wish to load a mat-file or an ASCI-Export(ASE)?','Load 3d-coordinates:','mat','ASE','mat');
    if strcmp(answer,'mat')
        [matfilename,matfilepath]=uigetfile('*.mat','Please choose *.mat-file:');
        matfile=[matfilepath,matfilename];
        load(matfile,'vertexmat','patchmat');
    elseif strcmp(answer,'ASE')
        [patchmat,vertexmat]=readASE([],[],1);
    end
end

x=zeros(vseg+1,hseg+1);
y=zeros(vseg+1,hseg+1);
z=zeros(vseg+1,hseg+1);

%matrizen von unten nach oben auffllen
%---------------------------------------

%Extrema
x(end,:)=ones(1,hseg+1)*vertexmat(end,1);
y(end,:)=ones(1,hseg+1)*vertexmat(end,2);
z(end,:)=ones(1,hseg+1)*vertexmat(end,3);
x(1,:)=ones(1,hseg+1)*vertexmat(1,1)
y(1,:)=ones(1,hseg+1)*vertexmat(1,2);
z(1,:)=ones(1,hseg+1)*vertexmat(1,3);

%Zwischenstufen
for a=1:vseg-1
    for b=1:hseg
        x(1+a,b)=vertexmat(1+(a-1)*(hseg)+b,1);
        y(1+a,b)=vertexmat(1+(a-1)*(hseg)+b,2);
        z(1+a,b)=vertexmat(1+(a-1)*(hseg)+b,3);
    end
    x(1+a,b+1)=x(1+a,1);
    y(1+a,b+1)=y(1+a,1);
    z(1+a,b+1)=z(1+a,1);
end


if displaystatus==1
	warning off
	figure
	surf(x,y,z)
	shading interp;
	material metal;

    lighting phong;
    axis equal;  material shiny;
    light('Position',[30 30 30],'Style','infinite','Color',[0.5 0.5 0.5]);
    light('Position',[-30 30 30],'Style','infinite','Color',[0.5 0.5 0.5]);
    light('Position',[30 -30 30],'Style','infinite','Color',[0.5 0.5 0.5]);
    light('Position',[-30 -30 30],'Style','infinite','Color',[0.5 0.5 0.5]);
	answer =questdlg('Do you wish to save the surface-matrices?','Save:','Yes','No','No');
	if strcmp(answer,'Yes')
		[savefilename,savefilepath]=uiputfile('*.mat','Please name the 3d-file:');
		if isempty(findstr(savefilename,'.mat'))
            savefilename=[savefilename,'.mat'];
		end
        head3dx=x;
        head3dy=y;
        head3dz=z;
		save([savefilepath,savefilename],'head3dx','head3dy','head3dz');
	end
else
    savefilename=['surface3d','.mat'];
    savefilepath=pwd;
	save([savefilepath,savefilename],'x','y','z');
end

return

