% Exercise 8.11

load snowfall
x = 0:140;
n = length(snowfall);
h = 1.06*sqrt(var(snowfall))*n^(-1/5);
fhat = zeros(size(x));
% Loop over all values of x in the domain
% to get the kernel evaluated at that point.
for i = 1:length(x)
		xloc = x(i)*ones(1,n);
		% Take each value of x and evaluate it at 
		% n weighted kernels - 
		% each one centered at a data point, then add them up. 
		arg = ((xloc-snowfall)/h).^2;
		fhat(i) = (sum(exp(-.5*(arg)))/(n*h*sqrt(2*pi)));
end

