%This is the multiple color map demo
%used for Plate 10

% Define color map.
colormap([hsv(32);hot(32);cool(32);flag(32)]);

% Create first subplot using first quarter of color map.
subplot(221)
x = 0:.02:5*pi;
y = sin(x);
surface([x;x],[y;y],0*[x;x],[y;y],...
        'face','none','edge','flat','linewidth',3)
set(gca,'box','on');
axis([min(x) max(x) [min(y) max(y)]*1.1 ])
% Use equations found at beginning of this section.
cmin = min(y) - (1 - 1)*(max(y)-min(y))/(32 - 1 + 1);
cmax = min(y) + (128 - 1 + 1)*(max(y)-min(y))/(32 - 1 + 1);
caxis([cmin cmax]);

% Create second subplot using middle half of color map.
subplot(222)
u = 0:.02:10*pi;
x = exp(-.05*u).*cos(u);
y = exp(-.05*u).*sin(u);
z = .05*u;
surface([x;x],[y;y],[z;z],[z;z],...
        'face','none','edge','flat','linewidth',2)
view(3);axis([-1 1 -1 1 0 1.5]);grid;
set(gca,'ztick',[0 .5 1 1.5])
% Use equations found at beginning of this section.
cmin = min(z)- (33 - 1)*(max(z)-min(z))/(96 - 33 + 1);
cmax = min(z)+ (128 - 33 + 1)*(max(z)-min(z))/(96 - 33 + 1);
caxis([cmin cmax]);

% Create third subplot using last quarter of color map.
subplot(223)
x = 0:.2:5*pi;
y = sin(x);
surface([x;x],[y;y],0*[x;x],[y;y],...
        'face','none','edge','flat','linewidth',.5)
set(gca,'box','on');
axis([0 5*pi -1.1 1.1])
% Use equations found at beginning of this section.
cmin = min(y)- (97 - 1)*(max(y)-min(y))/(128 - 97 + 1);
cmax = min(y)+ (128 - 97 + 1)*(max(y)-min(y))/(128 - 97 + 1);
caxis([cmin cmax])
caxis([-7 1])

% Create fourth subplot using middle half of color map..
subplot(224)
u = 0:.02:10*pi;
x = exp(-.05*u).*cos(u);
y = exp(-.05*u).*sin(u);
z = .05*u;
surface([x;x],[y;y],[z;z],[z;z],...
        'face','none','edge','flat','linewidth',2)
% Use equations found at beginning of this section.
cmin = min(z) - (33 - 1)*(max(z)-min(z))/(96 - 33 + 1);
cmax = min(z) + (128 - 33 + 1)*(max(z)-min(z))/(96 - 33 + 1);
caxis([cmin cmax])
set(gca,'box','on');
