xx = [0 0 1 1 0 NaN 0 1 NaN 1 0;...
      0 0 1 1 0 NaN 0 1 NaN 1 0];
yy = [0 1 1 0 0 NaN 1 1 NaN 1 1;...
      0 1 1 0 0 NaN 0 0 NaN 0 0];
zz = [1 1 1 1 1 NaN 1 1 NaN 0 0;...
      0 0 0 0 0 NaN 1 1 NaN 0 0];
% Set up rotation variables.
rotation_increment = 5; % degrees
rotation_axis = [0 0 1];
rotation_origin = [0 0 0];
num_of_incr = 360/rotation_increment;
% Generate 3 translated versions of the cube.
s1_h = surf([xx]-.5,[yy]-.5,[zz]-.5);
set(s1_h, 'erasemode','background','facecolor','g');
s2_h = surface([xx]+1.5,[yy]+1.5,[zz]+1,...
       'erasemode','background','facecolor','r');
s3_h = surface([xx]+1.5,[yy],[zz]-0.5,...
       'erasemode','background','facecolor','b');
% Set up the proper proportions.
axis([-3 3 -3 3 -3 3]);axis('square');
grid off;
% Define the rotation specifications for each cube.
for loop = 1:num_of_incr
   rotate(s1_h,rotation_axis,...
                rotation_increment,rotation_origin);
   rotate(s2_h,rotation_axis+[1 1 0],...
                rotation_increment,rotation_origin+1);
   rotate(s3_h,rotation_axis,...
                rotation_increment,rotation_origin);
   drawnow;
end
