%Section 7.5.3.3 Axis Location and Position
%For Figures 7.15 and 7.16

figure;
plot(0:9,[0:9].^2);
a1=gca;
a2=axes;
plot(-10:10,[-10:10].^3);
set (a2,'xaxislocation','top','yaxislocation','right',...
        'color','none');
pause
numxticka1=length(get(a1,'xtick'));
xlima2=get(a2,'xlim');
xincr=(abs(diff(xlima2))/(numxticka1-1));
newxtks = [xlima2(1):xincr: xlima2(2)];
set(a2,'xtick',newxtks);
display('New XTicks set')
pause
numyticka1=length(get(a1,'ytick'));
ylima2=get(a2,'ylim');
yincr=(abs(diff(ylima2))/(numyticka1-1));
newytks = [ylima2(1):yincr: ylima2(2)];
set(a2,'ytick',newytks);
display('New YTicks set')
pause

% Rounding may not always be appropriate, but is done
% on the next two lines to make the graph look cleaner.
set(a2,'xticklabel',round(get(a2,'xtick')))
set(a2,'yticklabel',round(get(a2,'ytick')))
