function rgbimage = makergb(bitmap,colormap)
%RGBIMAGE = MAKERGB(BITMAP,COLORMAP)
%where BITMAP is a NxM array, and COLORMAP is a Cx3 double array
%RGBIMAGE will be a NxMx3 double array.
%Makes an RGB image from an array of indexes (BITMAP)into 
%a color map (COLORMAP).
%MAKERGB will determine if the index array needs to be 1-shifted.


bitmap=double(bitmap);
if min(bitmap(:))==0 %is it 0 indexed?
    offset=1
else
    offset=0
end

[rows,cols]=size(bitmap);

for L=1:3
    layer=colormap(bitmap(:,:)+offset,L);
    layer=reshape(layer,rows,cols);
    rgbimage(:,:,L)=layer;
    
end





