function x=rotcube()
%CUBE is a function to demonstrate run-time animation.
%A cube is drawn with lines.
%Use the arrow keys to control the direction of rotation.
%ESC key to exit.

x = [0 1 1 0 0 0 1 1 0 0 NaN 1 1 NaN 1 1 NaN 0 0];
y = [0 0 1 1 0 0 0 1 1 0 NaN 0 0 NaN 1 1 NaN 1 1];
z = [0 0 0 0 0 1 1 1 1 1 NaN 1 0 NaN 0 1 NaN 1 0];
rot_axis = [0 0 1];
rot_org = [0 0 0];

cube_h = plot3(x-0.5,y-0.5,z-0.5);

axis('square');
axis([-1 1 -1 1 -1 1]*2);
view=[-37,30];

set(cube_h,'erasemode','background');
rotation_increment = 5;

rotation_axis = rot_axis;
rotation_origin = rot_org;

fig_h=gcf;

key = 28;

while key ~= 27 % watch for ESC key
    if waitforbuttonpress == 1; 
    key = get(fig_h,'currentcharacter');
    
     switch key
        case 28    % <- rotate left
            rotation_axis = [0 0 1];
            rotation_increment = -5;
        case 29    % -> rotate right
            rotation_axis = [0 0 1];
            rotation_increment = 5;
        case 30    %  rotate up
            rotation_axis = [0 1 0];
            rotation_increment = 5;
        case 31    %  rotate down
            rotation_axis = [0 1 0];
            rotation_increment = -5;
        case 27 % ESC key
        close(fig_h)
        clear
        return
        
    end
    
        rotate(cube_h,rotation_axis,...
            rotation_increment,rotation_origin);
        drawnow;
    end
    
end
    
x=key;
%close(fig_h);


