% Example 10.1

% This shows the scatterplot procedure in Matlab.

% Use the scatter function with desired marker style.
% We have already seen how to do these in previous chapters using the plot
% function. So, we now show how to use the scatter (2-D) and scatter3 (3-D)
% functions.

% Basic syntax is SCATTER(X,Y,S,C,M). X and Y are the data vectors. The other
% arguments are optional. S is either a vector or a scalar indicating the area 
% (in points^2) of each marker. C is a vector of colors. M is an
% alternative marker; the default is a circle.

% First load up the data and get the variables of interest.
load oronsay
% Use the oronsay data set. Just plot two of the variables.
scatter(oronsay(:,8),oronsay(:,9))
xlabel(labcol{8})
ylabel(labcol{9})


% If we want to use different colors for the groups, 
% we can use the following syntax. Note that this 
% is not the only way to do the colors.
ind0 = find(midden==0); % Red
ind1 = find(midden==1); % Green
ind2 = find(midden==2); % Blue
C = zeros(length(midden),3);
C(ind0,1) = 1;
C(ind1,2) = 1;
C(ind2,3) = 1;
scatter(oronsay(:,8),oronsay(:,9),5,C)
xlabel(labcol{8})
ylabel(labcol{9})
zlabel(labcol{10})

% Now show scatter3 function. Syntax is the same;
% just add third vector.
scatter3(oronsay(:,8),oronsay(:,9),oronsay(:,10),5,C)
xlabel(labcol{8})
ylabel(labcol{9})
zlabel(labcol{10})
