% Example 10.11
% Shows how to get Andrews curves for a 
% small data set.

% Get the domain over which to plot the functions.
t = linspace(-pi,pi);
% Evaluate the curve for each observation.
f1 = 2/sqrt(2) + 6*sin(t) + 4*cos(t);
f2 = 5/sqrt(2) + 7*sin(t) + 3*cos(t);
f3 = 1/sqrt(2) + 8*sin(t) + 9*cos(t);
plot(t,f1,'-.',t,f2,':',t,f3,'--')
legend('F1','F2','F3')
xlabel('t')
