% Example 10.14
% This shows the use of grand tour in k dimensions. 
% We provide a function called kdimtour that implements the torus grand
% tour in K dimensions. The user can specify the maximum number of
% iterations, the type of display (Andrews' curves or parallel
% coordinates), and the number of dimensions k.

% We show first the tour at several iterations.
% Parallel coordinates will be used here. Andrews' curves are left as an
% exercise.
% We see that this shows some grouping of the lines - all seem to follow
% the same 'structure'.
% We just use topic 6 data from Example 10.13 and 10.4.
ind6 = find(classlab==6);
x = X(ind6,:);
kdimtour(x,10,3)

% Now at the 90th iteration. 
% We see that the grouping falls apart.
kdimtour(x,90,3)
