% Example 10.5
% This shows how to do linking in a brute-force way.

% We will use plotmatrix again here, but note that using gplotmatrix might
% be a simpler way to go.

load oronsay
X = [oronsay(:,7),oronsay(:,8),oronsay(:,9),];
% Get the initial plot.
% We need some of the handles to the subplots.
[H,AX,BigAx,P,PAx] = plotmatrix(X,'o');
Hdots = findobj('type','line');
set(Hdots,'markersize',2)

% The matrix AX contains the handles to the axes.
% Loop through these and change observation 71 to 
% different marker.
% Get the point that will be linked.
linkpt = X(71,:);
% Remove it from the other matrix.
X(71,:) = [];
% Now change in all of the plots.
for i = 1:2
    for j = (i+1):3
        % Change that observation to 'x'.
        axes(AX(i,j))
        cla, axis manual
        line('xdata',linkpt(j),'ydata',linkpt(i),...
            'markersize',5,'marker','x')
        line('xdata',X(:,j),'ydata',X(:,i),...
            'markersize',2,'marker','o',...
            'linestyle','none')
        axes(AX(j,i))
        cla, axis manual
        line('xdata',linkpt(i),'ydata',linkpt(j),...
            'markersize',5,'marker','x')
        line('xdata',X(:,i),'ydata',X(:,j),...
            'markersize',2,'marker','o',...
            'linestyle','none')
    end
end

% Of course, gplotmatrix would be a lot easier! 



