% Example 10.7
% This shows the use of coplots.
% Reference for this example is Cleveland, Chapter 4
% and the Data Viz Tool (Book_4_3.m)

load abrasion
% Get the data into one matrix.
X = [hardness(:) tensile(:) abrasion(:)];
labels = {'Hardness'; 'Tensile Strength';...
        'Abrasion Loss'};

% Set up the parameters for the coplot.
% These are the parameters for the intervals.
np = 6;     % Number of given intervals.
overlap = 3/4;  % Amount of interval overlap.
intervalParams = [np overlap];
%  Parameters for loess curve
alpha = 3/4;
lambda = 1;
robustFlag = 0;
fitParams = [alpha lambda robustFlag];
% Call the function.
coplot(X,labels,intervalParams,fitParams)
