% Example 10.9
% This shows how to use the multiway function.

load oronsay
% Get the means according to each midden class.
% The beachdune variable contains class 
% labels for midden (0), beach (1), and
% dune (2). Get the means for each group.
ind = find(beachdune==0);
middenmus = mean(oronsay(ind,:));
ind = find(beachdune==1);
beachmus = mean(oronsay(ind,:));
ind = find(beachdune==2);
dunemus = mean(oronsay(ind,:));
X = [middenmus(:), beachmus(:), dunemus(:)];
% Get the labels for the groups and axes.
bdlabs = {'Midden'; 'Beach'; 'Dune'};
labx = 'Average Particle Weight';
% Get the location information for the plots.
sublocs{1} = [1,3];
sublocs{2} = [1 2 3];
multiwayplot(X,labcol,labx,bdlabs,sublocs)
