% try to reproduce the plot in Golub, Figure 3B. This shows the normalized
% genes for ALL and AML. The data are standardized.
% Example 1.1

% First standardize the data such that each row has mean 0 and standard
% deviation 1.
load leukemia
x = leukemia(:,1:38);
[n,p]=size(x);
y = zeros(n,p);
for i = 1:n
    sig = std(x(i,:));
    mu = mean(x(i,:));
    y(i,:)= (x(i,:)-mu)/sig;
end

% Now do the image of the data.
pcolor(y)
colormap(gray(256))
colorbar
title('Gene Expression for Leukemia')
xlabel('ALL (1-27) or AML (28-38)')
ylabel('Gene')


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Alternative ways of doing the normalization below are offered by Ton
% Lane, The MathWorks.

% Sample data
load hald
x = ingredients;

% Method used in text
[m,p] = size(x);
y = zeros(m,p);
for i=1:m
   sig = std(x(i,:));
   mu = mean(x(i,:));
   y(i,:) = (x(i,:) - mu) / sig;
end

% No loop
[m,p] = size(x);
sig = std(x,0,2);
mu = mean(x,2);
y2 = (x - repmat(mu,1,p)) ./ repmat(sig,1,p);

% zscore
y3 = zscore(x')';

% the same or very close
the_difference = max(abs(y(:)-y2(:)))
the_difference = max(abs(y(:)-y3(:)))
