% We show how to sphere data in this example.

% First generate some 2-D multivariate normal
% random varibles, with mean MU and 
% covariance SIGMA. This is a Statistics
% Toolbox function.
n = 100;
mu = [-2, 2];
sigma = [1,.5;.5,1];
X = mvnrnd(mu,sigma,n);
plot(X(:,1),X(:,2),'.')

% Now sphere the data.
muhat = mean(X);
[V,D] = eig(cov(X));
Xc = X - ones(n,1)*muhat;
Z = ((D)^(-1/2)*V'*Xc')';
plot(Z(:,1),Z(:,2),'.')


