% Example 2.1
% In this example we illustrate the concept of projections, using a very
% simple data set of 2 points.

% Enter the data as rows of our matrix X.
X = [4 3; -4 5];

% plot the data.
plot(X(:,1),X(:,2),'x')
axis([-9 9 -9 9])
hold on
plot([-9 9], [0 0])
plot([0 0],[-9 9])

% Get theta
theta = pi/3;

c2 = cos(theta)^2;
cs = cos(theta)*sin(theta);
s2 = sin(theta)^2;

P = [c2 cs; cs s2];

% Now plot the theta-line
x = [-9*cos(theta) 9*cos(theta)];
y = [-9*sin(theta) 9*sin(theta)];
plot(x,y)

% Now project the data onto the theta-line
Xp = X*P;
plot(Xp(:,1),Xp(:,2),'o')

% Of course, this does not reduce the dimensionality. 
% We can project onto the 1-D space given by the horizontal axis by using
% the projection:
Px = [1;0];
Xpx = X*Px;
plot(Xpx(:,1),[0 0],'p')

