% Example 2.3 - Singular Value Decomposition
% This example comes from the paper 'Using linear algebra for intelligent
% information retrieval,' by Betty, Dumais and O'Brien, 1995, SIAM Review.
% pages 2 - 24.

load lsiex
% Loads up a variables: X, termdoc, docs and words.
% Note that we do not center the data matrix.
% Convert the matrix where the columns have magnitude of 1.
[n,p] = size(X);
for i = 1:p
    termdoc(:,i) = X(:,i)/norm(X(:,i));
end

% Set up the query vectors
q1 = [1 0 1 0 0 0]';
q2 = [1 0 0 0 0 0]';

% Find the cosine of the angle between columns of termdoc and query
m1 = norm(q1);
cosq1a = q1'*termdoc/m1;
cosq2a = q2'*termdoc;

% Find the singular value decomposition.
[u,s,v] = svd(termdoc);

% Project the query vectors.
q1t = u(:,1:3)'*q1;
q2t = u(:,1:3)'*q2;
% Now find the cosine of the angle between the query vector  
% and the columns of the reduced rank matrix.
% Note that this uses Equation 6.1 of Berry, Drmac and Jessup.
% To increase recall at the expense of precision, one could
% divide by the magnitude of the transformed query vectors
% q1t and q2t within the loop. (Equation 6.2)
for i = 1:p
    sj = d(1:3,1:3)*v(i,1:3)';
    m3 = norm(sj);
    cosq1b(i) = sj'*q1t/(m3*m1);
    cosq2b(i) = sj'*q2t/(m3);
end


% Leave this part for exercises.
% Find a rank 3 approximation based on SVD.
x3 = u(:,1:3)*s(1:3,1:3)*v(:,1:3)';   
% Try it their other way: columns of A_3 compared to query vector.
for i = 1:p
    x3(:,i) = x3(:,i)/norm(x3(:,i));
end
cosq1c = q1'*x3/norm(q1);
cosq2c = q2'*x3;

% More exercises: try rank 2 approximation. How are the results?


