% Example 2.4 - Factor Analysis
% The functions used in this example are available in the Matlab Statistics
% Toolbox, Version 4. This example is a variation of the example provided
% in the toolbox documentation, starting on page 7-13.

load stockreturns	 %loads up a variable called stocks
% Perform factor analysis:3 factors,default rotation.
[LamVrot,PsiVrot] = factoran(stocks,3); 

% Perform factor analysis: 3 factors, no rotation.
[Lam,Psi] = factoran(stocks,3, 'rotate','none'); 

% Plot 1st factor loadings vs. 2nd factor loadings
plot(Lam(:,1),Lam(:,2),'k.')
text(Lam(:,1),Lam(:,2), num2str((1:10)')); 
line([-1 1],[0 0],'Color','k');
line([0 0],[-1 1],'Color','k');
xlabel('Factor 1'); ylabel('Factor 2')
title('No rotation')

% Now plot the 1st vs. the 3rd.
figure
plot(Lam(:,1),Lam(:,3),'k.')
text(Lam(:,1),Lam(:,3), num2str((1:10)')); 
line([-1 1],[0 0],'Color','k');
line([0 0],[-1 1],'Color','k');
xlabel('Factor 1'); ylabel('Factor 3')
title('No rotation')

% Now try the promax rotation
[LProt,PProt] = factoran(stocks,3,'rotate','promax');
% Plot 1st factor loadings vs. 2nd factor loadings
plot(LProt(:,1),LProt(:,2),'k.')
text(LProt(:,1),LProt(:,2), num2str((1:10)')); 
line([-1 1],[0 0],'Color','k');
line([0 0],[-1 1],'Color','k');
xlabel('Factor 1'); ylabel('Factor 2')
title('Promax rotation')

% Now plot the 1st vs. the 3rd.
figure
plot(LProt(:,1),LProt(:,3),'k.')
text(LProt(:,1),LProt(:,3), num2str((1:10)')); 
line([-1 1],[0 0],'Color','k');
line([0 0],[-1 1],'Color','k');
xlabel('Factor 1'); ylabel('Factor 3')
title('Promax rotation')

