% Example 3.4. Illustrates Kruskal's algorithm for nonmetric MDS.

load ochiaibpm
% First get out the data for topics 8 and 11. 
% Find the indices where they are equal to 8 or 11.
indlab = find(classlab ~= 8 & classlab ~= 11);
% Now get rid of these from the distance matrix.
ochiaibpm(indlab,:) = [];
ochiaibpm(:,indlab)=[];
classlab(indlab) = [];
% Now, we only need the upper part
n = length(classlab);
dissim = [];
for i = 1:n
    dissim = [dissim, ochiaibpm(i,(i+1):n)];
end

d = 2;
r = 1;
[Xd,stress,dhats] = nmmds(dissim,d,r);

ind8 = find(classlab==8);
ind11 = find(classlab==11);
plot(Xd(ind8,1),Xd(ind8,2),'.',...
    Xd(ind11,1),Xd(ind11,2),'o')
legend({'Topic 8';'Topic 11'})

save example34
