% Example 3.5
% This shows how to use LLE, ISOMAP, and Hessian Eigenmaps.

% First for LLE, using the S-curve code off of the LLE website.
N=2000;
% First set up some parameters for LLE.
K=12;
d=2; 
% PLOT TRUE MANIFOLD
% The code for the following was taken from the LLE website.
tt = [-1:0.1:0.5]*pi; uu = tt(end:-1:1); hh = [0:0.1:1]*5;
xx = [cos(tt) -cos(uu)]'*ones(size(hh));
yy = ones(size([tt uu]))'*hh;
zz = [sin(tt) 2-sin(uu)]'*ones(size(hh));
cc = [tt uu]' * ones(size(hh));
surf(xx,yy,zz,cc);
view([12 -20 3]);

% This generates the data.
angle = pi*(1.5*rand(1,N/2)-1); height = 5*rand(1,N);
X = [[cos(angle), -cos(angle)];height;[ sin(angle), 2-sin(angle)]];
% Note that X is 3 x 2000 - really the transpose of our usual
% way of doing the data matrix.
scatter3(X(1,:),X(2,:),X(3,:),12,[angle angle],'+','filled');
view([12 -20 3]);

% RUN LLE ALGORITHM
% Note that the data matrix input argument is p x n.
% Don't need to actually run this. The Y array is saved
% in scurve.mat.
Y=lle(X,K,d);
scatter(Y(1,:),Y(2,:),12,[angle angle],'+','filled');

% Now run the ISOMAP - we need the distances for input.
dists = squareform(pdist(X'));
options.dims = 1:10;    % These are for ISOMAP.
options.display = 0;
[Yiso, Riso, Eiso] = isomap(dists, 'k', 7, options);

% Now run the example from Grimes and Donoho.
% Saved in swissroll.dat
load swissroll
options.dims = 1:10;
options.display = 0;
dists = squareform(pdist(X'));
[Yiso, Riso, Eiso] = isomap(dists, 'k', 7, options);
% To get the coordinates, look in the structure Yiso. Note that the
% coordinates are also in the form dim x observ. If we want a 2-D
% scatter plot, then we use the 2nd record. Typing in Yiso at the
% command line shows what is in the structure.
scatter(Yiso.coords{2}(1,:), Yiso.coords{2}(2,:), 12, tt, '+');
set(gca,'xcolor','k')
set(gca,'ycolor','k')
set(gca,'zcolor','k')
set(gcf,'color','w')

% Now for the Hessian LLE
Y2 = hlle(X,K,d);
scatter(Y2(1,:),Y2(2,:),12,tt,'+');
set(gca,'xcolor','k')
set(gca,'ycolor','k')
set(gca,'zcolor','k')
set(gcf,'color','w')








