% Example 3.7
% GTM Example

load oronsay
noLatPts = 400;
noBasisFn = 81;
sigma = 1.5;
[X,MU,FI,W,beta] = gtm_stp2(oronsay,noLatPts,...
    noBasisFn,sigma);
lambda = 0.001;
cycles = 40;
[trndW,trndBeta,llhLog] = gtm_trn(oronsay,FI,W,...
    lambda,cycles,beta,'quiet');
mus = gtm_pmn(oronsay,X,FI,trndW,trndBeta);
modes = gtm_pmd(oronsay,X,FI,trndW);

ind0 = find(midden==0);
ind1 = find(midden==1);
ind2 = find(midden==2);
plot(mus(ind0,1),mus(ind0,2),'k.',mus(ind1,1),...
    mus(ind1,2),'kx',mus(ind2,1),mus(ind2,2),'ko')
