% Example 4.1 Torus Winding Tour
load yeast
[n,p] = size(data);
% Set up vector of frequencies.
N = 2*p - 3;
lam = mod(exp(1:N),1);
% This is a small irrational number:
delt = exp(1)^(-5); 
% Get the indices to build the rotations.
J = 2:p;
I = ones(1,length(J));
I = [I, 2*ones(1,length(J)-1)];
J = [J, 3:p];
E = eye(p,2);   % Basis vectors
maxit = 2150;

% Get an initial plot.
z = zeros(n,2);
ph = plot(z(:,1),z(:,2),'o','erasemode','normal');
axis equal, axis off
set(gcf,'backingstore','off','renderer','painters','DoubleBuffer','on')
% Start the tour.
for k = 1:maxit
    % Find the rotation matrix.
    Q = eye(p);
    for j = 1:N
        dum = eye(p);
        dum([I(j),J(j)],[I(j),J(j)]) = cos(lam(j)*k*delt);
        dum(I(j),J(j)) = -sin(lam(j)*k*delt);
        dum(J(j),I(j)) = sin(lam(j)*k*delt);
        Q = Q*dum;
    end
    % Rotate basis vectors.
    A = Q*E;
    % Project onto the new basis vectors.
    z = data*A;
    set(ph,'xdata',z(:,1),'ydata',z(:,2))
    pause(0.02)
end

