% Figure 5.1
% The purpose of this example is to illustrate the procedure for using
% Matlab - hierarchical clustering.  We will use the yeast data for this.
% Single linkage will show chaining, complete linkage will show none.

load yeast
% Get the distances. The output from this function is a vector of the
% n(n-1)/2 interpoint distances. Default is Euclidean.
Y = pdist(data);
% Single linkage - the default - shows chaining.
Z = linkage(Y);
dendrogram(Z);

% Complete linkage does not have the chaining.
Z = linkage(Y,'complete');
dendrogram(Z);

% To get the actual clusters - say based
% on two partitions, use the following
% syntax.
cind = cluster(Z,'maxclust',2);