% This shows the k-means algorithm

load iris
data = [setosa; versicolor; virginica];
vars = ['Sepal Length';
        'Sepal Width ';
        'Petal Length';
        'Petal Width '];
 kmus = kmeans(data,3);
   

% Now plot
[H,Ax,BigAxK] = gplotmatrix(data,data,kmus,'rgb','o+x',2,'off','none',vars,vars);
title('Results from K Means')

% get rid of the diagonal stuff - by hand
subplot(Ax(1,1)),cla
subplot(Ax(2,2)),cla
subplot(Ax(3,3)),cla
subplot(Ax(4,4)),cla

% Get some labels to group the true values.
labs = [ones(1,50),2*ones(1,50),3*ones(1,50)];
figure
[H,Ax,BigAxT] = gplotmatrix(data,data,labs,'rgb','o+x',2.5,'off','none',vars,vars);
title('Actual Groups')

subplot(Ax(1,1)),cla
subplot(Ax(2,2)),cla
subplot(Ax(3,3)),cla
subplot(Ax(4,4)),cla

save example52

