% Example 5.3
% IN this example, we will compare the results from the k-means
% and the true group labels for the iris data.

load example52

% Get some of the preliminary information.
ukmus = unique(kmus); ulabs = unique(labs);
n1 = length(ukmus); n2 = length(ulabs);
n = length(kmus);
% Now find the matching matrix N
N = zeros(n1,n2);
I = 0; 
for i = ukmus(:)'
    I = I + 1;
    J = 0;
    for j = ulabs(:)'
        J = J + 1;
        indI = find(kmus == i);
        indJ = find(labs == j);
        N(I,J) = length(intersect(indI,indJ));
    end
end
nc2 = nchoosek(n,2);
nidot = sum(N);
njdot = sum(N');
ntot = sum(sum(N.^2));
num = nc2+ntot-0.5*sum(nidot.^2)- 0.5*sum(njdot.^2);
ri = num/nc2;

% Now use the adjusted Rand index function.
ari = adjrand(kmus,labs);