% Example 5.4
% shows the function for the cophenetic correlation coefficient.

% Use the results from Example 5.1, where we used complete and single 
% linkage on the yeast data.

load yeast
% Get the Euclidean distances.
Y = pdist(data);
% Single linkage output.
Zs = linkage(Y);
% Now get the cophenetic coefficient.
scoph = cophenet(Zs,Y);

% Now do the same thing for the complete linkage.
Zc = linkage(Y,'complete');
ccoph = cophenet(Zc,Y);