% Example 5.5
% This shows the graphical Mojena rule.

% We will do this somewhat differently, so it is in 
% keeping with the types of 'elbow' plots in previous
% chapters and applcations. 
load lungB
% Get the distances and the linkage.
% Use the standardized Euclidean distance.
Y = pdist(lungB','seuclidean');
Z = linkage(Y,'complete');
% Plot dendrogram with fewer leaf nodes.
dendrogram(Z,15);

nc = 10;
% Flip the Z matrix - makes it easier.
Zf = flipud(Z);
% Now get the vector of means
% and standard deviations
for i = 1:nc
    abar(i) = mean(Zf(i:end,3));
    astd(i) = std(Zf(i:end,3));
end
% Get the y values for plotting.
yv = (Zf(1:nc,3) - abar(:))./astd(:);
xv = 1:nc;
plot(xv,yv,'-o')
xlabel('Number of Clusters')
ylabel('Standardized Fusion Levels')

% We can also plot just the fusion levels
% and look for the elbow.
plot(1:nc,Zf(1:nc,3),'o-')
xlabel('Number of Clusters')
ylabel('Raw Fusion Levels')
