% Example 5.6
% This illustrates the use of the silhouette statistic and plots.
% We return to the k-means example using the iris data.

load iris
data = [setosa; versicolor; virginica];
% Get a k-means clustering using 3 clusters,
% and 5 replicates. We also ask MATLAB to
% display the final results for each replicate.
kmus3 = kmeans(data,3,...
    'replicates',5,'display','final');
% Get a k-means clustering using 4 clusters.
kmus4 = kmeans(data,4,...
    'replicates',5,'display','final');

% Get the silhouette and the values.
[sil3, h3] = silhouette(data, kmus3);

[sil4, h4] = silhouette(data, kmus4);

mean(sil3)
mean(sil4)