% Example 6.6
% This one shows how to do agglomerative model-
% based clustering.

% Load up the data and put into a data matrix.
load iris
X = [setosa; versicolor; virginica];
% Do the agglomerative model-based clustering.
% This function is included in the EDA Toolbox
% and the MBC Toolbox.
Z = agmbclust(X);

% Construct a dendrogram.
dendrogram(Z);
title('Results for Iris Data - Agglomerative MBC')

% We can apply the silhouette procedure for this
% after we find a partition. Use 3 groups.
cind = cluster(Z,3);
[S,H] = silhouette(X,cind);
title('Silhouette Plot - Agglomerative MBC')

