%  Example 7.2 Shows 2-D loess
% Calls loess2 from downloaded function.
% This function and example came from the
% Data Visualization Toolbox.

% First load the data and set some parameters.
load galaxy
% The following is for the contour plot.
contvals = 1420:30:1780;
% These are the parameters needed for loess.
alpha = 0.25;
lambda = 2;

% Now we get the points in the domain.
% The loess surface will be evaluated
% at these points.
XI = -25:2:25;
YI = -45:2:45;
[newx,newy] = meshgrid(XI,YI);
newz = loess2(EastWest,NorthSouth,...
    Velocity,newx,newy,alpha,lambda,1);

% Now do the contour plot and add labels.
[cs,h] = contour(newx,newy,newz,contvals);
clabel(cs,h)
xlabel('East-West Coordinate (arcsec)')
ylabel('North-South Coordinate (arcsec)')

