% Example 7.3 - Robust Loess

% Load the data and set the values
% for x and y.
load salmon
x = salmon(:,1);
y = salmon(:,2);
% Get a domain over which to get
% the loess curve.
xo = linspace(min(x),max(x));
% Get both the regular loess.
yhat = loess(x,y,xo,0.6,2);
% Get the robust loess curve.
yhatr = loessr(x,y,xo,0.6,2);
% Plot both curves.
plot(xo,yhat,'-',xo,yhatr,':',x,y,'o')
legend({'Loess';'Robust Loess'})
xlabel('Spawners')
ylabel('Recruits')


