% Example 7.7
% This shows the pairs of smooths in a scatterplot matrix.

load software
% Get some things needed for plotting.
vars = ['log Prep/SLOC';' log Mtg/SLOC';' log Def/SLOC'];
% Transform the data using logs.
X = log(prepsloc);
Y = log(mtgsloc);
Z = log(defsloc);
% Set up the parameters.
alpha = 0.5;
lambda = 2;
n = length(X);

% Get the pairs of middle smoothings.
% There should be 6 unique cases of these.
% First get domains.
x0 = linspace(min(X),max(X),50);
y0 = linspace(min(Y),max(Y),50);
z0 = linspace(min(Z),max(Z),50);
% Now get the curves. 
xhatvy = loess(Y,X,y0,alpha,lambda);
yhatvx = loess(X,Y,x0,alpha,lambda);
xhatvz = loess(Z,X,z0,alpha,lambda);
zhatvx = loess(X,Z,x0,alpha,lambda);
yhatvz = loess(Z,Y,z0,alpha,lambda);
zhatvy = loess(Y,Z,y0,alpha,lambda);

% Now do the plotmatrix. 
data = [X(:),Y(:),Z(:)];
[H,AX,BigAx] = gplotmatrix(data,[],[],'k','.',...
    0.75,[],'none',vars,vars);
% Use Handle Graphics to construct the lines.
axes(AX(1,2));
line(y0,xhatvy);line(yhatvx,x0,'LineStyle','--');
axes(AX(1,3));
line(z0,xhatvz);line(zhatvx,x0,'LineStyle','--');
axes(AX(2,1));
line(x0,yhatvx);line(xhatvy,y0,'LineStyle','--');
axes(AX(2,3));
line(z0,yhatvz);line(zhatvy,y0,'LineStyle','--');
axes(AX(3,1));
line(x0,zhatvx);line(xhatvz,z0,'LineStyle','--');
axes(AX(3,2));
line(y0,zhatvy);line(yhatvz,z0,'LineStyle','--');

