% Example 8.1

% First load the data.
load leukemia
[n,p] = size(leukemia);
x = zeros(n,p);
% Standardize each row (gene) to be mean
% zero and standard deviation 1.
for i = 1:n
    sig = std(leukemia(i,:));
    mu = mean(leukemia(i,:));
    x(i,:) = (leukemia(i,:) - mu)/sig;
end
% Do hierarchical clustering.
Y = pdist(x);
Z = linkage(Y,'complete');
[H, T] = dendrogram(Z,15);
title('Leukemia Data')

ind = find(T==6)
