% Example 8.4
% Show how to use ReClus function.
% These data are saved in example84.mat.

load L1bpm
% Get just those topics on 5 through 11
ind = find(classlab == 5);
ind = [ind; find(classlab == 6)];
ind = [ind; find(classlab == 8)];
ind = [ind; find(classlab == 9)];
ind = [ind; find(classlab == 11)];
% Change the class labels for class 11
% for better plotting.
clabs = classlab(ind);
clabs(find(clabs==11)) = 1;

% First do dimensionality reduction - ISOMAP
[Y, R, E] = isomap(L1bpm,'k',10);
% Choose 3 dimensions, based on residual variance.
XX = Y.coords{3}';
% Only need those observations in classes of interest.
X = XX(ind,:);
% Now do model-based clustering.
[bics,bestm,allm,Z,clabsmbc] = mbclust(X,10);

% Get probability does not belong to cluster.
[clabsB,uncB] = mixclass(X,bestm.pies,bestm.mus,bestm.vars);
% Plot with true class labels.
% Function requires the posterior probability.
reclus(clabsB,clabs,1 - uncB)

% Look at the other option in reclus.
% Plot points with posterior probability above
% 0.9 in bold, black font.
reclus(clabsB,clabs,1 - uncB,.9)


