% Example 8.5
% Just use topics 8 and 11 for smaller set.

% Continuing with same data used in 
% Example 8.4.
ind = find(classlab == 8);
ind = [ind; find(classlab == 11)];
clabs = classlab(ind);
% Change the class labels for class 11
% for better plotting.
clabs = classlab(ind);
clabs(find(clabs==11)) = 1;
% Only need those observations in classes of interest.
X = XX(ind,:);

% Get the hierarchical clustering.
Y = pdist(X);
Z = linkage(Y,'complete');
dendrogram(Z);
cids = cluster(Z,'maxclust',2);
% Now get the silhouette values.
S = silhouette(X,cids);

% The following plots the observation
% numbers, with 'pointers' to the
% true class labels plotted next.
reclus(cids, clabs)
% Now plot same thing, but with true
% class labels.
reclus(cids,clabs,S)

