% Example 8.6
% This shows how to do the data image.


load iris
% Put into one matrix.
data = [setosa;versicolor;virginica];
% Randomly re-order the data.
data = data(randperm(150),:);
% Construct the data image.
imagesc(-1*data)
colormap(gray(256))

% Now get the ordering using hierarchical 
% clustering and the dendrogram.
Y = pdist(data);
Z = linkage(Y,'complete');
% Plot both the dendrogram and the data
% image together.
figure
subplot(1,2,1)
[H, T, perm] = dendrogram(Z,0,'orientation','left');
axis off
subplot(1,2,2),imagesc(flipud(-1*data(perm,:)))
colormap(gray(256))

