% Example 9.5
% This one shows how to do a boxplot by hand.

% First get the quartiles. Use the function that
% comes with the EDA book.

load software
% Take the log of the data.
x = log(sort(defsloc));
n = length(x);
% First get the quartiles.
q = quartiles(x);
% Find the interquartile range.
iq = q(3) - q(1);
% Find the outer limits.
UL = q(3) + 1.5*iq;
LL = q(1) - 1.5*iq;
% Find any outliers.
ind = [find(x > UL); find(x < LL)];
outs = x(ind);
% Get the adjacent values. Find the
% points that are NOT outliers.
inds = setdiff(1:n,ind);
% Get their min and max.
adv = [x(inds(1)) x(inds(end))];

% Now draw the necessary pieces.
% Draw the quartiles.
plot([1 3],[q(1),q(1)])
hold on
plot([1 3],[q(2),q(2)])
plot([1 3],[q(3),q(3)])
% Draw the sides of the box
plot([1 1],[q(1),q(3)])
plot([3 3],[q(1),q(3)])
% Draw the whiskers.
plot([2 2],[q(1),adv(1)], [1.75 2.25], [adv(1) adv(1)]) 
plot([2 2],[q(3),adv(2)], [1.75 2.25], [adv(2) adv(2)])
% Now draw the outliers with symbols.
plot(2*ones(size(outs)), outs,'o')
hold off
axs = axis;
axis([-1 5 axs(3:4)])
set(gca,'XTickLabel',' ')
ylabel('Defects per SLOC (log)')

