% Example 9.6

% Generate some standard normal data.
X(:,1) = randn(400,1);
% Generate some uniform data.
tmp = 2.4*rand(398,1) - 1.2;
% Add some outliers to it.
X(:,2) = [tmp; [-2.9 2.9]'];
tmp1 = randn(300,1)*.5;
tmp2 = randn(50,1)*.4-2;
tmp3 = randn(50,1)*.4+2;
X(:,3) = [tmp1; tmp2; tmp3];
save  example96 X

% This is from the Statistics Toolbox:
figure,boxplot(X,0,[],1,10)

% We can get the histplot. This function is 
% included with this text.
boxp(X,'hp')

% Let's see what these look like using the
% box-percentile plot.
boxprct(X)


boxprct(X,'vw')