% Example 9.7
% This example illustrates the procedure for constructing 
% a probability plot.


load galaxy
% We will use the EastWest data again.
x = sort(EastWest);
n = length(x);
% Get the probabilities.
prob = ((1:n)-0.5)/n;
% Now get the theoretical quantiles for
% a normal distribution.
qp = norminv(prob,0,1);
% Now plot theoretical quantiles versus 
% the sorted data.
plot(qp,x,'.')
ylabel('Sorted Data')
xlabel('Standard Normal Quantiles')


