% Example 9.9
% In this example, we look at the case of a q-q plot where the sample sizes
% are different.

% We will generate some samples - one will be
% from the normal distribution, the other will
% be uniform.
n = 100;
m = 75;
x = randn(1,n);
y = rand(1,m);

% Sort both of them - order statistics.
ys = sort(y);
% Now find the associated quantiles using the x.
% Probabilities for quantiles:
p = ((1:m) - 0.5)/m;							
xs = quantiles(x,p);

% Construct the plot.
plot(xs,ys,'.')
% Get the reference line. Use the 1st and 3rd 
% quartiles of each set to get a line.
qy = quartiles(y);
qx = quartiles(x);
[pol, s] = polyfit(qx([1,3]),qy([1,3]),1);
% Add the line to the figure.
yhat = polyval(pol,xs);
hold on
plot(xs,yhat,'k')
xlabel('Sample Quantiles - X'),
ylabel('Sorted Y Values')
hold off

axis([-4 4 -1 2])

