function [x1,beta,v] = gen_hh(x)
%GEN_HH Generate a Householder transformation.
%
% [x1,beta,v] = gen_hh(x)
%
% Given a vector x, gen_hh computes the scalar beta and the vector v
% determining a Householder transformation
%    H = (I - beta*v*v'),
% such that H*x = +-norm(x)*e_1. x1 is the first element of H*x.

% Per Christian Hansen, UNI-C, 05/13/1989.

v = x; alpha = norm(v);
if (alpha==0),
  beta = 0;
else
  beta = 1/(alpha*(alpha + abs(v(1))));
end
v(1) = v(1) + sign(v(1))*alpha; x1 = -sign(x(1))*alpha;
