function [NAA,x_0] = pinit(W,A,b)
%PINIT Utility init.-procedure for "preconditioned" iterative methods.
%
% NAA = pinit(W,A)
% [NAA,x_0] = pinit(W,A,b)
%
% Initialization for `preconditioning' of general-form problems.
% Here, W holds a basis for the null space of L.
%
% Determines the matrix NAA needed in the iterative routines for
% treating regularization problems in general form.
%
% If b is also specified then x_0, the component of the solution in
% the null space of L, is also computed.

% Reference: M. Hanke, "Regularization with differential operators.
% An iterative approach", J. Numer. Funct. Anal. Optim. 13 (1992),
% 523-540.

% Per Christian Hansen, UNI-C, and Martin Hanke, Institut fuer
% Praktische Mathematik, Universitaet Karlsruhe, 05/26/93.
 
% Initialization.
[n,nu] = size(W);

% Special treatment of square L.
if (nu==0), NAA = []; x_0 = zeros(n,1); return, end

% Compute NAA.
T = pinv(A*W);
NAA = T*A;

% If required, also compute x_0.
if (nargin==3), x_0 = W*(T*b); end
